/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CaptionResult
implements JsonSerializable<CaptionResult> {
    private final double confidence;
    private final String text;

    private CaptionResult(double confidence, String text) {
        this.confidence = confidence;
        this.text = text;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String getText() {
        return this.text;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    public static CaptionResult fromJson(JsonReader jsonReader) throws IOException {
        return (CaptionResult)jsonReader.readObject(reader -> {
            double confidence = 0.0;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new CaptionResult(confidence, text);
        });
    }
}

