/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.ai.vision.imageanalysis.models.CaptionResult;
import com.azure.ai.vision.imageanalysis.models.DenseCaptionsResult;
import com.azure.ai.vision.imageanalysis.models.ImageMetadata;
import com.azure.ai.vision.imageanalysis.models.ObjectsResult;
import com.azure.ai.vision.imageanalysis.models.PeopleResult;
import com.azure.ai.vision.imageanalysis.models.ReadResult;
import com.azure.ai.vision.imageanalysis.models.SmartCropsResult;
import com.azure.ai.vision.imageanalysis.models.TagsResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageAnalysisResult
implements JsonSerializable<ImageAnalysisResult> {
    private CaptionResult caption;
    private DenseCaptionsResult denseCaptions;
    private final ImageMetadata metadata;
    private final String modelVersion;
    private ObjectsResult objects;
    private PeopleResult people;
    private ReadResult read;
    private SmartCropsResult smartCrops;
    private TagsResult tags;

    private ImageAnalysisResult(ImageMetadata metadata, String modelVersion) {
        this.metadata = metadata;
        this.modelVersion = modelVersion;
    }

    public CaptionResult getCaption() {
        return this.caption;
    }

    public DenseCaptionsResult getDenseCaptions() {
        return this.denseCaptions;
    }

    public ImageMetadata getMetadata() {
        return this.metadata;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ObjectsResult getObjects() {
        return this.objects;
    }

    public PeopleResult getPeople() {
        return this.people;
    }

    public ReadResult getRead() {
        return this.read;
    }

    public SmartCropsResult getSmartCrops() {
        return this.smartCrops;
    }

    public TagsResult getTags() {
        return this.tags;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", (JsonSerializable)this.metadata);
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeJsonField("captionResult", (JsonSerializable)this.caption);
        jsonWriter.writeJsonField("denseCaptionsResult", (JsonSerializable)this.denseCaptions);
        jsonWriter.writeJsonField("objectsResult", (JsonSerializable)this.objects);
        jsonWriter.writeJsonField("peopleResult", (JsonSerializable)this.people);
        jsonWriter.writeJsonField("readResult", (JsonSerializable)this.read);
        jsonWriter.writeJsonField("smartCropsResult", (JsonSerializable)this.smartCrops);
        jsonWriter.writeJsonField("tagsResult", (JsonSerializable)this.tags);
        return jsonWriter.writeEndObject();
    }

    public static ImageAnalysisResult fromJson(JsonReader jsonReader) throws IOException {
        return (ImageAnalysisResult)jsonReader.readObject(reader -> {
            ImageMetadata metadata = null;
            String modelVersion = null;
            CaptionResult caption = null;
            DenseCaptionsResult denseCaptions = null;
            ObjectsResult objects = null;
            PeopleResult people = null;
            ReadResult read = null;
            SmartCropsResult smartCrops = null;
            TagsResult tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metadata".equals(fieldName)) {
                    metadata = ImageMetadata.fromJson(reader);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    continue;
                }
                if ("captionResult".equals(fieldName)) {
                    caption = CaptionResult.fromJson(reader);
                    continue;
                }
                if ("denseCaptionsResult".equals(fieldName)) {
                    denseCaptions = DenseCaptionsResult.fromJson(reader);
                    continue;
                }
                if ("objectsResult".equals(fieldName)) {
                    objects = ObjectsResult.fromJson(reader);
                    continue;
                }
                if ("peopleResult".equals(fieldName)) {
                    people = PeopleResult.fromJson(reader);
                    continue;
                }
                if ("readResult".equals(fieldName)) {
                    read = ReadResult.fromJson(reader);
                    continue;
                }
                if ("smartCropsResult".equals(fieldName)) {
                    smartCrops = SmartCropsResult.fromJson(reader);
                    continue;
                }
                if ("tagsResult".equals(fieldName)) {
                    tags = TagsResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            ImageAnalysisResult deserializedImageAnalysisResult = new ImageAnalysisResult(metadata, modelVersion);
            deserializedImageAnalysisResult.caption = caption;
            deserializedImageAnalysisResult.denseCaptions = denseCaptions;
            deserializedImageAnalysisResult.objects = objects;
            deserializedImageAnalysisResult.people = people;
            deserializedImageAnalysisResult.read = read;
            deserializedImageAnalysisResult.smartCrops = smartCrops;
            deserializedImageAnalysisResult.tags = tags;
            return deserializedImageAnalysisResult;
        });
    }
}

