/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.ai.vision.imageanalysis.models.ImagePoint;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DetectedTextWord
implements JsonSerializable<DetectedTextWord> {
    private final String text;
    private final List<ImagePoint> boundingPolygon;
    private final double confidence;

    private DetectedTextWord(String text, List<ImagePoint> boundingPolygon, double confidence) {
        this.text = text;
        this.boundingPolygon = boundingPolygon;
        this.confidence = confidence;
    }

    public String getText() {
        return this.text;
    }

    public List<ImagePoint> getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingPolygon", this.boundingPolygon, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeDoubleField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static DetectedTextWord fromJson(JsonReader jsonReader) throws IOException {
        return (DetectedTextWord)jsonReader.readObject(reader -> {
            String text = null;
            List boundingPolygon = null;
            double confidence = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("boundingPolygon".equals(fieldName)) {
                    boundingPolygon = reader.readArray(reader1 -> ImagePoint.fromJson(reader1));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return new DetectedTextWord(text, boundingPolygon, confidence);
        });
    }
}

