/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SentimentTaskResult
extends AnalyzeTextTaskResult {
    private AnalyzeTextTaskResultsKind kind = AnalyzeTextTaskResultsKind.SENTIMENT_ANALYSIS_RESULTS;
    private SentimentResponse results;

    @Override
    public AnalyzeTextTaskResultsKind getKind() {
        return this.kind;
    }

    public SentimentResponse getResults() {
        return this.results;
    }

    public SentimentTaskResult setResults(SentimentResponse results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static SentimentTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentTaskResult)jsonReader.readObject(reader -> {
            SentimentTaskResult deserializedSentimentTaskResult = new SentimentTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("results".equals(fieldName)) {
                    deserializedSentimentTaskResult.results = SentimentResponse.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSentimentTaskResult.kind = AnalyzeTextTaskResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentimentTaskResult;
        });
    }
}

