/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.HealthcareAssertion;
import com.azure.ai.textanalytics.implementation.models.HealthcareEntityLink;
import com.azure.ai.textanalytics.models.HealthcareEntityCategory;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class HealthcareEntity
implements JsonSerializable<HealthcareEntity> {
    private String text;
    private HealthcareEntityCategory category;
    private String subcategory;
    private int offset;
    private int length;
    private double confidenceScore;
    private HealthcareAssertion assertion;
    private String name;
    private List<HealthcareEntityLink> links;

    public String getText() {
        return this.text;
    }

    public HealthcareEntity setText(String text) {
        this.text = text;
        return this;
    }

    public HealthcareEntityCategory getCategory() {
        return this.category;
    }

    public HealthcareEntity setCategory(HealthcareEntityCategory category) {
        this.category = category;
        return this;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public HealthcareEntity setSubcategory(String subcategory) {
        this.subcategory = subcategory;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public HealthcareEntity setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public HealthcareEntity setLength(int length) {
        this.length = length;
        return this;
    }

    public double getConfidenceScore() {
        return this.confidenceScore;
    }

    public HealthcareEntity setConfidenceScore(double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }

    public HealthcareAssertion getAssertion() {
        return this.assertion;
    }

    public HealthcareEntity setAssertion(HealthcareAssertion assertion) {
        this.assertion = assertion;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public HealthcareEntity setName(String name) {
        this.name = name;
        return this;
    }

    public List<HealthcareEntityLink> getLinks() {
        return this.links;
    }

    public HealthcareEntity setLinks(List<HealthcareEntityLink> links) {
        this.links = links;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("category", this.category == null ? null : this.category.toString());
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeDoubleField("confidenceScore", this.confidenceScore);
        jsonWriter.writeStringField("subcategory", this.subcategory);
        jsonWriter.writeJsonField("assertion", (JsonSerializable)this.assertion);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("links", this.links, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HealthcareEntity fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareEntity)jsonReader.readObject(reader -> {
            HealthcareEntity deserializedHealthcareEntity = new HealthcareEntity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedHealthcareEntity.text = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedHealthcareEntity.category = HealthcareEntityCategory.fromString(reader.getString());
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    deserializedHealthcareEntity.offset = reader.getInt();
                    continue;
                }
                if ("length".equals(fieldName)) {
                    deserializedHealthcareEntity.length = reader.getInt();
                    continue;
                }
                if ("confidenceScore".equals(fieldName)) {
                    deserializedHealthcareEntity.confidenceScore = reader.getDouble();
                    continue;
                }
                if ("subcategory".equals(fieldName)) {
                    deserializedHealthcareEntity.subcategory = reader.getString();
                    continue;
                }
                if ("assertion".equals(fieldName)) {
                    deserializedHealthcareEntity.assertion = HealthcareAssertion.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedHealthcareEntity.name = reader.getString();
                    continue;
                }
                if ("links".equals(fieldName)) {
                    List links;
                    deserializedHealthcareEntity.links = links = reader.readArray(reader1 -> HealthcareEntityLink.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareEntity;
        });
    }
}

