/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.TaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class CustomTaskParameters
extends TaskParameters {
    private String projectName;
    private String deploymentName;

    public String getProjectName() {
        return this.projectName;
    }

    public CustomTaskParameters setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public CustomTaskParameters setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    @Override
    public CustomTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", this.isLoggingOptOut());
        jsonWriter.writeStringField("projectName", this.projectName);
        jsonWriter.writeStringField("deploymentName", this.deploymentName);
        return jsonWriter.writeEndObject();
    }

    public static CustomTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CustomTaskParameters)jsonReader.readObject(reader -> {
            CustomTaskParameters deserializedCustomTaskParameters = new CustomTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggingOptOut".equals(fieldName)) {
                    deserializedCustomTaskParameters.setLoggingOptOut((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedCustomTaskParameters.projectName = reader.getString();
                    continue;
                }
                if ("deploymentName".equals(fieldName)) {
                    deserializedCustomTaskParameters.deploymentName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomTaskParameters;
        });
    }
}

