/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsAsyncClient;
import com.azure.ai.textanalytics.TextAnalyticsClientBuilder;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.models.AbstractiveSummaryOperationDetail;
import com.azure.ai.textanalytics.models.AbstractiveSummaryOptions;
import com.azure.ai.textanalytics.models.AnalyzeActionsOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeActionsOptions;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOptions;
import com.azure.ai.textanalytics.models.AnalyzeSentimentOptions;
import com.azure.ai.textanalytics.models.AnalyzeSentimentResult;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.ClassifyDocumentOperationDetail;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.DetectLanguageResult;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.DocumentSentiment;
import com.azure.ai.textanalytics.models.ExtractKeyPhraseResult;
import com.azure.ai.textanalytics.models.ExtractiveSummaryOperationDetail;
import com.azure.ai.textanalytics.models.ExtractiveSummaryOptions;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.MultiLabelClassifyOptions;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOptions;
import com.azure.ai.textanalytics.models.RecognizeEntitiesResult;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesResult;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesOptions;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesResult;
import com.azure.ai.textanalytics.models.SingleLabelClassifyOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsActions;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AbstractiveSummaryPagedIterable;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedIterable;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedIterable;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.ai.textanalytics.util.ClassifyDocumentPagedIterable;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.ai.textanalytics.util.ExtractiveSummaryPagedIterable;
import com.azure.ai.textanalytics.util.RecognizeCustomEntitiesPagedIterable;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

@ServiceClient(builder=TextAnalyticsClientBuilder.class)
public final class TextAnalyticsClient {
    private static final ClientLogger LOGGER = new ClientLogger(TextAnalyticsClient.class);
    private final TextAnalyticsAsyncClient client;

    TextAnalyticsClient(TextAnalyticsAsyncClient client) {
        this.client = client;
    }

    public String getDefaultCountryHint() {
        return this.client.getDefaultCountryHint();
    }

    public String getDefaultLanguage() {
        return this.client.getDefaultLanguage();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectedLanguage detectLanguage(String document) {
        return this.detectLanguage(document, this.client.getDefaultCountryHint());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectedLanguage detectLanguage(String document, String countryHint) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        DetectLanguageResultCollection resultCollection = this.detectLanguageBatch(Collections.singletonList(document), countryHint, null);
        DetectedLanguage detectedLanguage = null;
        Iterator iterator = resultCollection.iterator();
        while (iterator.hasNext()) {
            DetectLanguageResult detectLanguageResult = (DetectLanguageResult)iterator.next();
            if (detectLanguageResult.isError()) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(detectLanguageResult.getError())));
            }
            detectedLanguage = detectLanguageResult.getPrimaryLanguage();
        }
        return detectedLanguage;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectLanguageResultCollection detectLanguageBatch(Iterable<String> documents, String countryHint, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (DetectLanguageResultCollection)((Object)this.detectLanguageBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> new DetectLanguageInput((String)index, (String)value, countryHint)), options, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DetectLanguageResultCollection> detectLanguageBatchWithResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return this.client.detectLanguageUtilClient.getDetectedLanguageResponseSync(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CategorizedEntityCollection recognizeEntities(String document) {
        return this.recognizeEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CategorizedEntityCollection recognizeEntities(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        RecognizeEntitiesResultCollection recognizeEntitiesResultCollectionMono = this.recognizeEntitiesBatch(Collections.singletonList(document), language, null);
        CategorizedEntityCollection entityCollection = null;
        Iterator iterator = recognizeEntitiesResultCollectionMono.iterator();
        while (iterator.hasNext()) {
            RecognizeEntitiesResult entitiesResult = (RecognizeEntitiesResult)iterator.next();
            if (entitiesResult.isError()) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
            }
            entityCollection = new CategorizedEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getWarnings());
        }
        return entityCollection;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizeEntitiesResultCollection recognizeEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (RecognizeEntitiesResultCollection)((Object)this.recognizeEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizeEntitiesResultCollection> recognizeEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return this.client.recognizeEntityUtilClient.getRecognizedEntitiesResponseSync(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PiiEntityCollection recognizePiiEntities(String document) {
        return this.recognizePiiEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PiiEntityCollection recognizePiiEntities(String document, String language) {
        return this.recognizePiiEntities(document, language, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PiiEntityCollection recognizePiiEntities(String document, String language, RecognizePiiEntitiesOptions options) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        RecognizePiiEntitiesResultCollection recognizePiiEntitiesResults = this.recognizePiiEntitiesBatch(Collections.singletonList(document), language, options);
        PiiEntityCollection entityCollection = null;
        Iterator iterator = recognizePiiEntitiesResults.iterator();
        while (iterator.hasNext()) {
            RecognizePiiEntitiesResult entitiesResult = (RecognizePiiEntitiesResult)iterator.next();
            if (entitiesResult.isError()) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
            }
            entityCollection = new PiiEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getRedactedText(), entitiesResult.getEntities().getWarnings());
        }
        return entityCollection;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizePiiEntitiesResultCollection recognizePiiEntitiesBatch(Iterable<String> documents, String language, RecognizePiiEntitiesOptions options) {
        return (RecognizePiiEntitiesResultCollection)((Object)this.recognizePiiEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizePiiEntitiesResultCollection> recognizePiiEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options, Context context) {
        return this.client.recognizePiiEntityUtilClient.getRecognizePiiEntitiesResponseSync(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedEntityCollection recognizeLinkedEntities(String document) {
        return this.recognizeLinkedEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedEntityCollection recognizeLinkedEntities(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        RecognizeLinkedEntitiesResultCollection resultCollectionResponse = this.recognizeLinkedEntitiesBatch(Collections.singletonList(document), language, null);
        LinkedEntityCollection linkedEntityCollection = null;
        Iterator iterator = resultCollectionResponse.iterator();
        while (iterator.hasNext()) {
            RecognizeLinkedEntitiesResult entitiesResult = (RecognizeLinkedEntitiesResult)iterator.next();
            if (entitiesResult.isError()) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
            }
            linkedEntityCollection = new LinkedEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getWarnings());
        }
        return linkedEntityCollection;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizeLinkedEntitiesResultCollection recognizeLinkedEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (RecognizeLinkedEntitiesResultCollection)((Object)this.recognizeLinkedEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizeLinkedEntitiesResultCollection> recognizeLinkedEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return this.client.recognizeLinkedEntityUtilClient.getRecognizedLinkedEntitiesResponseSync(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyPhrasesCollection extractKeyPhrases(String document) {
        return this.extractKeyPhrases(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyPhrasesCollection extractKeyPhrases(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        ExtractKeyPhrasesResultCollection resultCollectionResponse = this.extractKeyPhrasesBatch(Collections.singletonList(document), language, null);
        KeyPhrasesCollection keyPhrasesCollection = null;
        Iterator iterator = resultCollectionResponse.iterator();
        while (iterator.hasNext()) {
            ExtractKeyPhraseResult keyPhraseResult = (ExtractKeyPhraseResult)iterator.next();
            if (keyPhraseResult.isError()) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(keyPhraseResult.getError())));
            }
            keyPhrasesCollection = new KeyPhrasesCollection(keyPhraseResult.getKeyPhrases(), keyPhraseResult.getKeyPhrases().getWarnings());
        }
        return keyPhrasesCollection;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExtractKeyPhrasesResultCollection extractKeyPhrasesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (ExtractKeyPhrasesResultCollection)((Object)this.extractKeyPhrasesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExtractKeyPhrasesResultCollection> extractKeyPhrasesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return this.client.extractKeyPhraseUtilClient.getExtractedKeyPhrasesResponseSync(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document) {
        return this.analyzeSentiment(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document, String language) {
        return this.analyzeSentiment(document, language, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document, String language, AnalyzeSentimentOptions options) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        AnalyzeSentimentResultCollection sentimentResultCollection = this.analyzeSentimentBatch(Collections.singletonList(document), language, options);
        DocumentSentiment documentSentiment = null;
        Iterator iterator = sentimentResultCollection.iterator();
        while (iterator.hasNext()) {
            AnalyzeSentimentResult sentimentResult = (AnalyzeSentimentResult)iterator.next();
            if (sentimentResult.isError()) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(sentimentResult.getError())));
            }
            documentSentiment = sentimentResult.getDocumentSentiment();
        }
        return documentSentiment;
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeSentimentResultCollection analyzeSentimentBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        return (AnalyzeSentimentResultCollection)((Object)this.analyzeSentimentBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeSentimentResultCollection analyzeSentimentBatch(Iterable<String> documents, String language, AnalyzeSentimentOptions options) {
        return (AnalyzeSentimentResultCollection)((Object)this.analyzeSentimentBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE).getValue());
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeSentimentResultCollection> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        return this.analyzeSentimentBatchWithResponse(documents, new AnalyzeSentimentOptions().setIncludeStatistics(options == null ? false : options.isIncludeStatistics()).setModelVersion(options == null ? null : options.getModelVersion()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeSentimentResultCollection> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options, Context context) {
        return this.client.analyzeSentimentUtilClient.getAnalyzedSentimentResponseSync(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcareEntities(Iterable<String> documents) {
        return this.beginAnalyzeHealthcareEntities(documents, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcareEntities(Iterable<String> documents, String language, AnalyzeHealthcareEntitiesOptions options) {
        return this.beginAnalyzeHealthcareEntities(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcareEntities(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options, Context context) {
        return this.client.analyzeHealthcareEntityUtilClient.beginAnalyzeHealthcarePagedIterable(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedIterable> beginRecognizeCustomEntities(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginRecognizeCustomEntities(documents, projectName, deploymentName, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedIterable> beginRecognizeCustomEntities(Iterable<String> documents, String projectName, String deploymentName, String language, RecognizeCustomEntitiesOptions options) {
        return this.beginRecognizeCustomEntities(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedIterable> beginRecognizeCustomEntities(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, RecognizeCustomEntitiesOptions options, Context context) {
        return this.client.recognizeCustomEntitiesUtilClient.recognizeCustomEntitiesPagedIterable(documents, projectName, deploymentName, options, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginSingleLabelClassify(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginSingleLabelClassify(documents, projectName, deploymentName, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginSingleLabelClassify(Iterable<String> documents, String projectName, String deploymentName, String language, SingleLabelClassifyOptions options) {
        return this.beginSingleLabelClassify(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginSingleLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, SingleLabelClassifyOptions options, Context context) {
        return this.client.labelClassifyUtilClient.singleLabelClassifyPagedIterable(documents, projectName, deploymentName, options, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginMultiLabelClassify(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginMultiLabelClassify(documents, projectName, deploymentName, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginMultiLabelClassify(Iterable<String> documents, String projectName, String deploymentName, String language, MultiLabelClassifyOptions options) {
        return this.beginMultiLabelClassify(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginMultiLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, MultiLabelClassifyOptions options, Context context) {
        return this.client.labelClassifyUtilClient.multiLabelClassifyPagedIterable(documents, projectName, deploymentName, options, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedIterable> beginAbstractSummary(Iterable<String> documents) {
        return this.beginAbstractSummary(documents, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedIterable> beginAbstractSummary(Iterable<String> documents, String language, AbstractiveSummaryOptions options) {
        return this.client.abstractiveSummaryUtilClient.abstractiveSummaryPagedIterable(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedIterable> beginAbstractSummary(Iterable<TextDocumentInput> documents, AbstractiveSummaryOptions options, Context context) {
        return this.client.abstractiveSummaryUtilClient.abstractiveSummaryPagedIterable(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedIterable> beginExtractSummary(Iterable<String> documents) {
        return this.beginExtractSummary(documents, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedIterable> beginExtractSummary(Iterable<String> documents, String language, ExtractiveSummaryOptions options) {
        return this.client.extractiveSummaryUtilClient.extractiveSummaryPagedIterable(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedIterable> beginExtractSummary(Iterable<TextDocumentInput> documents, ExtractiveSummaryOptions options, Context context) {
        return this.client.extractiveSummaryUtilClient.extractiveSummaryPagedIterable(documents, options, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActions(Iterable<String> documents, TextAnalyticsActions actions) {
        return this.beginAnalyzeActions(documents, actions, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActions(Iterable<String> documents, TextAnalyticsActions actions, String language, AnalyzeActionsOptions options) {
        return this.client.analyzeActionsUtilClient.beginAnalyzeActionsIterable(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), actions, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActions(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options, Context context) {
        return this.client.analyzeActionsUtilClient.beginAnalyzeActionsIterable(documents, actions, options, context);
    }
}

