/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DetectedLanguage;
import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class LanguageDetectionDocumentResult
extends DocumentResult {
    private DetectedLanguage detectedLanguage;

    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    public LanguageDetectionDocumentResult setDetectedLanguage(DetectedLanguage detectedLanguage) {
        this.detectedLanguage = detectedLanguage;
        return this;
    }

    @Override
    public LanguageDetectionDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public LanguageDetectionDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public LanguageDetectionDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeJsonField("detectedLanguage", (JsonSerializable)this.detectedLanguage);
        return jsonWriter.writeEndObject();
    }

    public static LanguageDetectionDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (LanguageDetectionDocumentResult)jsonReader.readObject(reader -> {
            LanguageDetectionDocumentResult deserializedLanguageDetectionDocumentResult = new LanguageDetectionDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLanguageDetectionDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedLanguageDetectionDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedLanguageDetectionDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("detectedLanguage".equals(fieldName)) {
                    deserializedLanguageDetectionDocumentResult.detectedLanguage = DetectedLanguage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLanguageDetectionDocumentResult;
        });
    }
}

