/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsAsyncClient;
import com.azure.ai.textanalytics.TextAnalyticsClient;
import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.Constants;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImplBuilder;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImplBuilder;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureKeyCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={TextAnalyticsAsyncClient.class, TextAnalyticsClient.class})
public final class TextAnalyticsClientBuilder
implements AzureKeyCredentialTrait<TextAnalyticsClientBuilder>,
ConfigurationTrait<TextAnalyticsClientBuilder>,
EndpointTrait<TextAnalyticsClientBuilder>,
HttpTrait<TextAnalyticsClientBuilder>,
TokenCredentialTrait<TextAnalyticsClientBuilder> {
    private static final String DEFAULT_SCOPE = "https://cognitiveservices.azure.com/.default";
    private static final String NAME = "name";
    private static final String OCP_APIM_SUBSCRIPTION_KEY = "Ocp-Apim-Subscription-Key";
    private static final String TEXT_ANALYTICS_PROPERTIES = "azure-ai-textanalytics.properties";
    private static final String VERSION = "version";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy();
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    private static final HttpLogOptions DEFAULT_LOG_OPTIONS = new HttpLogOptions();
    private static final HttpHeaders DEFAULT_HTTP_HEADERS = new HttpHeaders();
    private static final String COGNITIVE_TRACING_NAMESPACE_VALUE = "Microsoft.CognitiveServices";
    private final ClientLogger logger = new ClientLogger(TextAnalyticsClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private Configuration configuration;
    private AzureKeyCredential credential;
    private String defaultCountryHint;
    private String defaultLanguage;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private HttpPipeline httpPipeline;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private TokenCredential tokenCredential;
    private TextAnalyticsServiceVersion version;
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;

    public TextAnalyticsClient buildClient() {
        return new TextAnalyticsClient(this.buildAsyncClient());
    }

    public TextAnalyticsAsyncClient buildAsyncClient() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        TextAnalyticsServiceVersion serviceVersion = this.version != null ? this.version : TextAnalyticsServiceVersion.getLatest();
        Objects.requireNonNull(this.endpoint, "'Endpoint' is required and can not be null.");
        HttpPipeline pipeline = this.httpPipeline;
        if (pipeline == null) {
            ClientOptions buildClientOptions = this.clientOptions == null ? DEFAULT_CLIENT_OPTIONS : this.clientOptions;
            HttpLogOptions buildLogOptions = this.httpLogOptions == null ? DEFAULT_LOG_OPTIONS : this.httpLogOptions;
            String applicationId = CoreUtils.getApplicationId((ClientOptions)buildClientOptions, (HttpLogOptions)buildLogOptions);
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new AddHeadersPolicy(DEFAULT_HTTP_HEADERS));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new UserAgentPolicy(applicationId, CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
            policies.add(new RequestIdPolicy());
            policies.addAll(this.perCallPolicies);
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)DEFAULT_RETRY_POLICY));
            policies.add(new AddDatePolicy());
            if (this.tokenCredential != null) {
                policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{DEFAULT_SCOPE}));
            } else if (this.credential != null) {
                policies.add(new AzureKeyCredentialPolicy(OCP_APIM_SUBSCRIPTION_KEY, this.credential));
            } else {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
            }
            policies.addAll(this.perRetryPolicies);
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpHeaders headers = new HttpHeaders();
            buildClientOptions.getHeaders().forEach(header -> headers.set(header.getName(), header.getValue()));
            if (headers.getSize() > 0) {
                policies.add(new AddHeadersPolicy(headers));
            }
            policies.add(new HttpLoggingPolicy(buildLogOptions));
            TracingOptions tracingOptions = null;
            if (this.clientOptions != null) {
                tracingOptions = this.clientOptions.getTracingOptions();
            }
            Tracer tracer = TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, COGNITIVE_TRACING_NAMESPACE_VALUE, tracingOptions);
            pipeline = new HttpPipelineBuilder().clientOptions(buildClientOptions).httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).tracer(tracer).build();
        }
        if (!this.isConsolidatedServiceVersion(this.version)) {
            TextAnalyticsClientImpl textAnalyticsAPI = new TextAnalyticsClientImplBuilder().endpoint(this.endpoint).apiVersion(serviceVersion.getVersion()).pipeline(pipeline).buildClient();
            return new TextAnalyticsAsyncClient(textAnalyticsAPI, serviceVersion, this.defaultCountryHint, this.defaultLanguage);
        }
        MicrosoftCognitiveLanguageServiceTextAnalysisImpl batchApiTextAnalyticsClient = new MicrosoftCognitiveLanguageServiceTextAnalysisImplBuilder().endpoint(this.endpoint).apiVersion(serviceVersion.getVersion()).pipeline(pipeline).buildClient();
        return new TextAnalyticsAsyncClient(batchApiTextAnalyticsClient, serviceVersion, this.defaultCountryHint, this.defaultLanguage);
    }

    public TextAnalyticsClientBuilder defaultLanguage(String language) {
        this.defaultLanguage = language;
        return this;
    }

    public TextAnalyticsClientBuilder defaultCountryHint(String countryHint) {
        this.defaultCountryHint = countryHint;
        return this;
    }

    public TextAnalyticsClientBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL.", ex));
        }
        this.endpoint = endpoint.endsWith("/") ? endpoint.substring(0, endpoint.length() - 1) : endpoint;
        return this;
    }

    public TextAnalyticsClientBuilder credential(AzureKeyCredential keyCredential) {
        this.credential = Objects.requireNonNull(keyCredential, "'keyCredential' cannot be null.");
        return this;
    }

    public TextAnalyticsClientBuilder credential(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        this.tokenCredential = tokenCredential;
        return this;
    }

    public TextAnalyticsClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public static HttpLogOptions getDefaultLogOptions() {
        return Constants.DEFAULT_LOG_OPTIONS_SUPPLIER.get();
    }

    public TextAnalyticsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public TextAnalyticsClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public TextAnalyticsClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public TextAnalyticsClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public TextAnalyticsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public TextAnalyticsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public TextAnalyticsClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public TextAnalyticsClientBuilder serviceVersion(TextAnalyticsServiceVersion version) {
        this.version = version;
        return this;
    }

    private boolean isConsolidatedServiceVersion(TextAnalyticsServiceVersion serviceVersion) {
        if (serviceVersion == null) {
            serviceVersion = TextAnalyticsServiceVersion.V2022_05_01;
        }
        return TextAnalyticsServiceVersion.V3_0 != serviceVersion && TextAnalyticsServiceVersion.V3_1 != serviceVersion;
    }

    static {
        Map properties = CoreUtils.getProperties((String)TEXT_ANALYTICS_PROPERTIES);
        CLIENT_NAME = properties.getOrDefault(NAME, "UnknownName");
        CLIENT_VERSION = properties.getOrDefault(VERSION, "UnknownVersion");
    }
}

