/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.ClassificationResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SingleClassificationDocument
implements JsonSerializable<SingleClassificationDocument> {
    private String id;
    private ClassificationResult classification;
    private List<DocumentWarning> warnings;
    private DocumentStatistics statistics;

    public String getId() {
        return this.id;
    }

    public SingleClassificationDocument setId(String id) {
        this.id = id;
        return this;
    }

    public ClassificationResult getClassification() {
        return this.classification;
    }

    public SingleClassificationDocument setClassification(ClassificationResult classification) {
        this.classification = classification;
        return this;
    }

    public List<DocumentWarning> getWarnings() {
        return this.warnings;
    }

    public SingleClassificationDocument setWarnings(List<DocumentWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public DocumentStatistics getStatistics() {
        return this.statistics;
    }

    public SingleClassificationDocument setStatistics(DocumentStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("classification", (JsonSerializable)this.classification);
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        return jsonWriter.writeEndObject();
    }

    public static SingleClassificationDocument fromJson(JsonReader jsonReader) throws IOException {
        return (SingleClassificationDocument)jsonReader.readObject(reader -> {
            SingleClassificationDocument deserializedSingleClassificationDocument = new SingleClassificationDocument();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSingleClassificationDocument.id = reader.getString();
                    continue;
                }
                if ("classification".equals(fieldName)) {
                    deserializedSingleClassificationDocument.classification = ClassificationResult.fromJson(reader);
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    deserializedSingleClassificationDocument.warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedSingleClassificationDocument.statistics = DocumentStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSingleClassificationDocument;
        });
    }
}

