/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.PiiCategory;
import com.azure.ai.textanalytics.implementation.models.PiiDomain;
import com.azure.ai.textanalytics.implementation.models.PreBuiltTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class PiiTaskParameters
extends PreBuiltTaskParameters {
    private PiiDomain domain;
    private List<PiiCategory> piiCategories;
    private StringIndexType stringIndexType;

    public PiiDomain getDomain() {
        return this.domain;
    }

    public PiiTaskParameters setDomain(PiiDomain domain) {
        this.domain = domain;
        return this;
    }

    public List<PiiCategory> getPiiCategories() {
        return this.piiCategories;
    }

    public PiiTaskParameters setPiiCategories(List<PiiCategory> piiCategories) {
        this.piiCategories = piiCategories;
        return this;
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public PiiTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    @Override
    public PiiTaskParameters setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public PiiTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", this.isLoggingOptOut());
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeStringField("domain", this.domain == null ? null : this.domain.toString());
        jsonWriter.writeArrayField("piiCategories", this.piiCategories, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("stringIndexType", this.stringIndexType == null ? null : this.stringIndexType.toString());
        return jsonWriter.writeEndObject();
    }

    public static PiiTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PiiTaskParameters)jsonReader.readObject(reader -> {
            PiiTaskParameters deserializedPiiTaskParameters = new PiiTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggingOptOut".equals(fieldName)) {
                    deserializedPiiTaskParameters.setLoggingOptOut((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedPiiTaskParameters.setModelVersion(reader.getString());
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    deserializedPiiTaskParameters.domain = PiiDomain.fromString(reader.getString());
                    continue;
                }
                if ("piiCategories".equals(fieldName)) {
                    List piiCategories;
                    deserializedPiiTaskParameters.piiCategories = piiCategories = reader.readArray(reader1 -> PiiCategory.fromString(reader1.getString()));
                    continue;
                }
                if ("stringIndexType".equals(fieldName)) {
                    deserializedPiiTaskParameters.stringIndexType = StringIndexType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPiiTaskParameters;
        });
    }
}

