/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LanguageDetectionTaskResult
extends AnalyzeTextTaskResult {
    private AnalyzeTextTaskResultsKind kind = AnalyzeTextTaskResultsKind.LANGUAGE_DETECTION_RESULTS;
    private LanguageDetectionResult results;

    @Override
    public AnalyzeTextTaskResultsKind getKind() {
        return this.kind;
    }

    public LanguageDetectionResult getResults() {
        return this.results;
    }

    public LanguageDetectionTaskResult setResults(LanguageDetectionResult results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static LanguageDetectionTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (LanguageDetectionTaskResult)jsonReader.readObject(reader -> {
            LanguageDetectionTaskResult deserializedLanguageDetectionTaskResult = new LanguageDetectionTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("results".equals(fieldName)) {
                    deserializedLanguageDetectionTaskResult.results = LanguageDetectionResult.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedLanguageDetectionTaskResult.kind = AnalyzeTextTaskResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLanguageDetectionTaskResult;
        });
    }
}

