/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class CustomResult
implements JsonSerializable<CustomResult> {
    private List<DocumentError> errors;
    private RequestStatistics statistics;
    private String projectName;
    private String deploymentName;

    public List<DocumentError> getErrors() {
        return this.errors;
    }

    public CustomResult setErrors(List<DocumentError> errors) {
        this.errors = errors;
        return this;
    }

    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    public CustomResult setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CustomResult setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public CustomResult setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("projectName", this.projectName);
        jsonWriter.writeStringField("deploymentName", this.deploymentName);
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        return jsonWriter.writeEndObject();
    }

    public static CustomResult fromJson(JsonReader jsonReader) throws IOException {
        return (CustomResult)jsonReader.readObject(reader -> {
            CustomResult deserializedCustomResult = new CustomResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedCustomResult.errors = errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedCustomResult.projectName = reader.getString();
                    continue;
                }
                if ("deploymentName".equals(fieldName)) {
                    deserializedCustomResult.deploymentName = reader.getString();
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedCustomResult.statistics = RequestStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomResult;
        });
    }
}

