/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.JobState;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasks;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class AnalyzeTextJobState
extends JobState {
    private TasksStateTasks tasks;
    private RequestStatistics statistics;

    public TasksStateTasks getTasks() {
        return this.tasks;
    }

    public AnalyzeTextJobState setTasks(TasksStateTasks tasks) {
        this.tasks = tasks;
        return this;
    }

    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    public AnalyzeTextJobState setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    @Override
    public AnalyzeTextJobState setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    @Override
    public AnalyzeTextJobState setCreatedDateTime(OffsetDateTime createdDateTime) {
        super.setCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public AnalyzeTextJobState setExpirationDateTime(OffsetDateTime expirationDateTime) {
        super.setExpirationDateTime(expirationDateTime);
        return this;
    }

    @Override
    public AnalyzeTextJobState setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AnalyzeTextJobState setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        super.setLastUpdatedDateTime(lastUpdatedDateTime);
        return this;
    }

    @Override
    public AnalyzeTextJobState setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public AnalyzeTextJobState setErrors(List<Error> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public AnalyzeTextJobState setNextLink(String nextLink) {
        super.setNextLink(nextLink);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime", this.getCreatedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreatedDateTime()));
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("lastUpdatedDateTime", this.getLastUpdatedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdatedDateTime()));
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("displayName", this.getDisplayName());
        jsonWriter.writeStringField("expirationDateTime", this.getExpirationDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getExpirationDateTime()));
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.getNextLink());
        jsonWriter.writeJsonField("tasks", (JsonSerializable)this.tasks);
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeTextJobState fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextJobState)jsonReader.readObject(reader -> {
            AnalyzeTextJobState deserializedAnalyzeTextJobState = new AnalyzeTextJobState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdDateTime".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setJobId(reader.getString());
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setLastUpdatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setDisplayName(reader.getString());
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setExpirationDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> Error.fromJson(reader1));
                    deserializedAnalyzeTextJobState.setErrors(errors);
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.setNextLink(reader.getString());
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.tasks = TasksStateTasks.fromJson(reader);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedAnalyzeTextJobState.statistics = RequestStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeTextJobState;
        });
    }
}

