/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class TaskState
implements JsonSerializable<TaskState> {
    private OffsetDateTime lastUpdateDateTime;
    private State status;

    public OffsetDateTime getLastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public TaskState setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        this.lastUpdateDateTime = lastUpdateDateTime;
        return this;
    }

    public State getStatus() {
        return this.status;
    }

    public TaskState setStatus(State status) {
        this.status = status;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdateDateTime", this.lastUpdateDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateDateTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static TaskState fromJson(JsonReader jsonReader) throws IOException {
        return (TaskState)jsonReader.readObject(reader -> {
            TaskState deserializedTaskState = new TaskState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedTaskState.lastUpdateDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTaskState.status = State.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskState;
        });
    }
}

