/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.CustomEntitiesTask;
import com.azure.ai.textanalytics.implementation.models.CustomMultiClassificationTask;
import com.azure.ai.textanalytics.implementation.models.CustomSingleClassificationTask;
import com.azure.ai.textanalytics.implementation.models.EntitiesTask;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTask;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationTask;
import com.azure.ai.textanalytics.implementation.models.KeyPhrasesTask;
import com.azure.ai.textanalytics.implementation.models.PiiTask;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTask;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class JobManifestTasks
implements JsonSerializable<JobManifestTasks> {
    private List<EntitiesTask> entityRecognitionTasks;
    private List<PiiTask> entityRecognitionPiiTasks;
    private List<KeyPhrasesTask> keyPhraseExtractionTasks;
    private List<EntityLinkingTask> entityLinkingTasks;
    private List<SentimentAnalysisTask> sentimentAnalysisTasks;
    private List<ExtractiveSummarizationTask> extractiveSummarizationTasks;
    private List<CustomEntitiesTask> customEntityRecognitionTasks;
    private List<CustomSingleClassificationTask> customSingleClassificationTasks;
    private List<CustomMultiClassificationTask> customMultiClassificationTasks;

    public List<EntitiesTask> getEntityRecognitionTasks() {
        return this.entityRecognitionTasks;
    }

    public JobManifestTasks setEntityRecognitionTasks(List<EntitiesTask> entityRecognitionTasks) {
        this.entityRecognitionTasks = entityRecognitionTasks;
        return this;
    }

    public List<PiiTask> getEntityRecognitionPiiTasks() {
        return this.entityRecognitionPiiTasks;
    }

    public JobManifestTasks setEntityRecognitionPiiTasks(List<PiiTask> entityRecognitionPiiTasks) {
        this.entityRecognitionPiiTasks = entityRecognitionPiiTasks;
        return this;
    }

    public List<KeyPhrasesTask> getKeyPhraseExtractionTasks() {
        return this.keyPhraseExtractionTasks;
    }

    public JobManifestTasks setKeyPhraseExtractionTasks(List<KeyPhrasesTask> keyPhraseExtractionTasks) {
        this.keyPhraseExtractionTasks = keyPhraseExtractionTasks;
        return this;
    }

    public List<EntityLinkingTask> getEntityLinkingTasks() {
        return this.entityLinkingTasks;
    }

    public JobManifestTasks setEntityLinkingTasks(List<EntityLinkingTask> entityLinkingTasks) {
        this.entityLinkingTasks = entityLinkingTasks;
        return this;
    }

    public List<SentimentAnalysisTask> getSentimentAnalysisTasks() {
        return this.sentimentAnalysisTasks;
    }

    public JobManifestTasks setSentimentAnalysisTasks(List<SentimentAnalysisTask> sentimentAnalysisTasks) {
        this.sentimentAnalysisTasks = sentimentAnalysisTasks;
        return this;
    }

    public List<ExtractiveSummarizationTask> getExtractiveSummarizationTasks() {
        return this.extractiveSummarizationTasks;
    }

    public JobManifestTasks setExtractiveSummarizationTasks(List<ExtractiveSummarizationTask> extractiveSummarizationTasks) {
        this.extractiveSummarizationTasks = extractiveSummarizationTasks;
        return this;
    }

    public List<CustomEntitiesTask> getCustomEntityRecognitionTasks() {
        return this.customEntityRecognitionTasks;
    }

    public JobManifestTasks setCustomEntityRecognitionTasks(List<CustomEntitiesTask> customEntityRecognitionTasks) {
        this.customEntityRecognitionTasks = customEntityRecognitionTasks;
        return this;
    }

    public List<CustomSingleClassificationTask> getCustomSingleClassificationTasks() {
        return this.customSingleClassificationTasks;
    }

    public JobManifestTasks setCustomSingleClassificationTasks(List<CustomSingleClassificationTask> customSingleClassificationTasks) {
        this.customSingleClassificationTasks = customSingleClassificationTasks;
        return this;
    }

    public List<CustomMultiClassificationTask> getCustomMultiClassificationTasks() {
        return this.customMultiClassificationTasks;
    }

    public JobManifestTasks setCustomMultiClassificationTasks(List<CustomMultiClassificationTask> customMultiClassificationTasks) {
        this.customMultiClassificationTasks = customMultiClassificationTasks;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("entityRecognitionTasks", this.entityRecognitionTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("entityRecognitionPiiTasks", this.entityRecognitionPiiTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("keyPhraseExtractionTasks", this.keyPhraseExtractionTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("entityLinkingTasks", this.entityLinkingTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sentimentAnalysisTasks", this.sentimentAnalysisTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("extractiveSummarizationTasks", this.extractiveSummarizationTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("customEntityRecognitionTasks", this.customEntityRecognitionTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("customSingleClassificationTasks", this.customSingleClassificationTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("customMultiClassificationTasks", this.customMultiClassificationTasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobManifestTasks fromJson(JsonReader jsonReader) throws IOException {
        return (JobManifestTasks)jsonReader.readObject(reader -> {
            JobManifestTasks deserializedJobManifestTasks = new JobManifestTasks();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("entityRecognitionTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.entityRecognitionTasks = reader.readArray(reader1 -> EntitiesTask.fromJson(reader1));
                    continue;
                }
                if ("entityRecognitionPiiTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.entityRecognitionPiiTasks = reader.readArray(reader1 -> PiiTask.fromJson(reader1));
                    continue;
                }
                if ("keyPhraseExtractionTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.keyPhraseExtractionTasks = reader.readArray(reader1 -> KeyPhrasesTask.fromJson(reader1));
                    continue;
                }
                if ("entityLinkingTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.entityLinkingTasks = reader.readArray(reader1 -> EntityLinkingTask.fromJson(reader1));
                    continue;
                }
                if ("sentimentAnalysisTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.sentimentAnalysisTasks = reader.readArray(reader1 -> SentimentAnalysisTask.fromJson(reader1));
                    continue;
                }
                if ("extractiveSummarizationTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.extractiveSummarizationTasks = reader.readArray(reader1 -> ExtractiveSummarizationTask.fromJson(reader1));
                    continue;
                }
                if ("customEntityRecognitionTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.customEntityRecognitionTasks = reader.readArray(reader1 -> CustomEntitiesTask.fromJson(reader1));
                    continue;
                }
                if ("customSingleClassificationTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.customSingleClassificationTasks = reader.readArray(reader1 -> CustomSingleClassificationTask.fromJson(reader1));
                    continue;
                }
                if ("customMultiClassificationTasks".equals(fieldName)) {
                    deserializedJobManifestTasks.customMultiClassificationTasks = reader.readArray(reader1 -> CustomMultiClassificationTask.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobManifestTasks;
        });
    }
}

