/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EntitiesTaskResult
extends AnalyzeTextTaskResult {
    private AnalyzeTextTaskResultsKind kind = AnalyzeTextTaskResultsKind.ENTITY_RECOGNITION_RESULTS;
    private EntitiesResult results;

    @Override
    public AnalyzeTextTaskResultsKind getKind() {
        return this.kind;
    }

    public EntitiesResult getResults() {
        return this.results;
    }

    public EntitiesTaskResult setResults(EntitiesResult results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static EntitiesTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntitiesTaskResult)jsonReader.readObject(reader -> {
            EntitiesTaskResult deserializedEntitiesTaskResult = new EntitiesTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("results".equals(fieldName)) {
                    deserializedEntitiesTaskResult.results = EntitiesResult.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedEntitiesTaskResult.kind = AnalyzeTextTaskResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntitiesTaskResult;
        });
    }
}

