/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentSentimentValue;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.SentenceSentiment;
import com.azure.ai.textanalytics.implementation.models.SentimentConfidenceScorePerLabel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentSentiment
implements JsonSerializable<DocumentSentiment> {
    private String id;
    private DocumentSentimentValue sentiment;
    private DocumentStatistics statistics;
    private SentimentConfidenceScorePerLabel confidenceScores;
    private List<SentenceSentiment> sentences;
    private List<DocumentWarning> warnings;

    public String getId() {
        return this.id;
    }

    public DocumentSentiment setId(String id) {
        this.id = id;
        return this;
    }

    public DocumentSentimentValue getSentiment() {
        return this.sentiment;
    }

    public DocumentSentiment setSentiment(DocumentSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    public DocumentStatistics getStatistics() {
        return this.statistics;
    }

    public DocumentSentiment setStatistics(DocumentStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public SentimentConfidenceScorePerLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    public DocumentSentiment setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    public List<SentenceSentiment> getSentences() {
        return this.sentences;
    }

    public DocumentSentiment setSentences(List<SentenceSentiment> sentences) {
        this.sentences = sentences;
        return this;
    }

    public List<DocumentWarning> getWarnings() {
        return this.warnings;
    }

    public DocumentSentiment setWarnings(List<DocumentWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("sentiment", this.sentiment.toString());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        jsonWriter.writeJsonField("confidenceScores", (JsonSerializable)this.confidenceScores);
        jsonWriter.writeArrayField("sentences", this.sentences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentSentiment fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentSentiment)jsonReader.readObject(reader -> {
            DocumentSentiment deserializedDocumentSentiment = new DocumentSentiment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDocumentSentiment.id = reader.getString();
                    continue;
                }
                if ("sentiment".equals(fieldName)) {
                    deserializedDocumentSentiment.sentiment = DocumentSentimentValue.fromString(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedDocumentSentiment.statistics = DocumentStatistics.fromJson(reader);
                    continue;
                }
                if ("confidenceScores".equals(fieldName)) {
                    deserializedDocumentSentiment.confidenceScores = SentimentConfidenceScorePerLabel.fromJson(reader);
                    continue;
                }
                if ("sentences".equals(fieldName)) {
                    deserializedDocumentSentiment.sentences = reader.readArray(reader1 -> SentenceSentiment.fromJson(reader1));
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings;
                    deserializedDocumentSentiment.warnings = warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentSentiment;
        });
    }
}

