/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.EntitiesTaskResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTaskResult;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseTaskResult;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionTaskResult;
import com.azure.ai.textanalytics.implementation.models.PiiTaskResult;
import com.azure.ai.textanalytics.implementation.models.SentimentTaskResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class AnalyzeTextTaskResult
implements JsonSerializable<AnalyzeTextTaskResult> {
    private AnalyzeTextTaskResultsKind kind = AnalyzeTextTaskResultsKind.fromString("AnalyzeTextTaskResult");

    public AnalyzeTextTaskResultsKind getKind() {
        return this.kind;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeTextTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextTaskResult)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AnalyzeTextTaskResult analyzeTextTaskResult;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("SentimentAnalysisResults".equals(discriminatorValue)) {
                    analyzeTextTaskResult = SentimentTaskResult.fromJson(readerToUse.reset());
                    return analyzeTextTaskResult;
                }
                if ("EntityRecognitionResults".equals(discriminatorValue)) {
                    analyzeTextTaskResult = EntitiesTaskResult.fromJson(readerToUse.reset());
                    return analyzeTextTaskResult;
                }
                if ("EntityLinkingResults".equals(discriminatorValue)) {
                    analyzeTextTaskResult = EntityLinkingTaskResult.fromJson(readerToUse.reset());
                    return analyzeTextTaskResult;
                }
                if ("PiiEntityRecognitionResults".equals(discriminatorValue)) {
                    analyzeTextTaskResult = PiiTaskResult.fromJson(readerToUse.reset());
                    return analyzeTextTaskResult;
                }
                if ("KeyPhraseExtractionResults".equals(discriminatorValue)) {
                    analyzeTextTaskResult = KeyPhraseTaskResult.fromJson(readerToUse.reset());
                    return analyzeTextTaskResult;
                }
                if ("LanguageDetectionResults".equals(discriminatorValue)) {
                    analyzeTextTaskResult = LanguageDetectionTaskResult.fromJson(readerToUse.reset());
                    return analyzeTextTaskResult;
                }
                analyzeTextTaskResult = AnalyzeTextTaskResult.fromJsonKnownDiscriminator(readerToUse.reset());
                return analyzeTextTaskResult;
            }
        });
    }

    static AnalyzeTextTaskResult fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextTaskResult)jsonReader.readObject(reader -> {
            AnalyzeTextTaskResult deserializedAnalyzeTextTaskResult = new AnalyzeTextTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedAnalyzeTextTaskResult.kind = AnalyzeTextTaskResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeTextTaskResult;
        });
    }
}

