/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.CustomEntitiesResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.CustomResult;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CustomEntitiesResult
extends CustomResult {
    private List<CustomEntitiesResultDocumentsItem> documents;

    public List<CustomEntitiesResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    public CustomEntitiesResult setDocuments(List<CustomEntitiesResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    @Override
    public CustomEntitiesResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public CustomEntitiesResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public CustomEntitiesResult setProjectName(String projectName) {
        super.setProjectName(projectName);
        return this;
    }

    @Override
    public CustomEntitiesResult setDeploymentName(String deploymentName) {
        super.setDeploymentName(deploymentName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("projectName", this.getProjectName());
        jsonWriter.writeStringField("deploymentName", this.getDeploymentName());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomEntitiesResult fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEntitiesResult)jsonReader.readObject(reader -> {
            CustomEntitiesResult deserializedCustomEntitiesResult = new CustomEntitiesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedCustomEntitiesResult.setErrors(errors);
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedCustomEntitiesResult.setProjectName(reader.getString());
                    continue;
                }
                if ("deploymentName".equals(fieldName)) {
                    deserializedCustomEntitiesResult.setDeploymentName(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedCustomEntitiesResult.setStatistics(RequestStatistics.fromJson(reader));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    List documents;
                    deserializedCustomEntitiesResult.documents = documents = reader.readArray(reader1 -> CustomEntitiesResultDocumentsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomEntitiesResult;
        });
    }
}

