/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.ExtractedSummaryDocumentResult;
import com.azure.ai.textanalytics.implementation.models.PreBuiltResult;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ExtractiveSummarizationResult
extends PreBuiltResult {
    private List<ExtractedSummaryDocumentResult> documents;

    public List<ExtractedSummaryDocumentResult> getDocuments() {
        return this.documents;
    }

    public ExtractiveSummarizationResult setDocuments(List<ExtractedSummaryDocumentResult> documents) {
        this.documents = documents;
        return this;
    }

    @Override
    public ExtractiveSummarizationResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public ExtractiveSummarizationResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public ExtractiveSummarizationResult setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExtractiveSummarizationResult fromJson(JsonReader jsonReader) throws IOException {
        return (ExtractiveSummarizationResult)jsonReader.readObject(reader -> {
            ExtractiveSummarizationResult deserializedExtractiveSummarizationResult = new ExtractiveSummarizationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedExtractiveSummarizationResult.setErrors(errors);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedExtractiveSummarizationResult.setModelVersion(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedExtractiveSummarizationResult.setStatistics(RequestStatistics.fromJson(reader));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    List documents;
                    deserializedExtractiveSummarizationResult.documents = documents = reader.readArray(reader1 -> ExtractedSummaryDocumentResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtractiveSummarizationResult;
        });
    }
}

