/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.EntitiesDocumentResult;
import com.azure.ai.textanalytics.implementation.models.Entity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CustomEntitiesResultDocumentsItem
extends EntitiesDocumentResult {
    @Override
    public CustomEntitiesResultDocumentsItem setEntities(List<Entity> entities) {
        super.setEntities(entities);
        return this;
    }

    @Override
    public CustomEntitiesResultDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public CustomEntitiesResultDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public CustomEntitiesResultDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("entities", this.getEntities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static CustomEntitiesResultDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEntitiesResultDocumentsItem)jsonReader.readObject(reader -> {
            CustomEntitiesResultDocumentsItem deserializedCustomEntitiesResultDocumentsItem = new CustomEntitiesResultDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCustomEntitiesResultDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedCustomEntitiesResultDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities = reader.readArray(reader1 -> Entity.fromJson(reader1));
                    deserializedCustomEntitiesResultDocumentsItem.setEntities(entities);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedCustomEntitiesResultDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomEntitiesResultDocumentsItem;
        });
    }
}

