/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatRole;
import com.azure.ai.inference.models.StreamingChatResponseToolCallUpdate;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class StreamingChatResponseMessageUpdate
implements JsonSerializable<StreamingChatResponseMessageUpdate> {
    private ChatRole role;
    private String content;
    private List<StreamingChatResponseToolCallUpdate> toolCalls;

    private StreamingChatResponseMessageUpdate() {
    }

    public ChatRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<StreamingChatResponseToolCallUpdate> getToolCalls() {
        return this.toolCalls;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static StreamingChatResponseMessageUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (StreamingChatResponseMessageUpdate)jsonReader.readObject(reader -> {
            StreamingChatResponseMessageUpdate deserializedStreamingChatResponseMessageUpdate = new StreamingChatResponseMessageUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedStreamingChatResponseMessageUpdate.role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedStreamingChatResponseMessageUpdate.content = reader.getString();
                    continue;
                }
                if ("tool_calls".equals(fieldName)) {
                    List toolCalls;
                    deserializedStreamingChatResponseMessageUpdate.toolCalls = toolCalls = reader.readArray(reader1 -> StreamingChatResponseToolCallUpdate.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStreamingChatResponseMessageUpdate;
        });
    }
}

