/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.CompletionsUsage;
import com.azure.ai.inference.models.StreamingChatChoiceUpdate;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class StreamingChatCompletionsUpdate
implements JsonSerializable<StreamingChatCompletionsUpdate> {
    private final String id;
    private final long created;
    private final String model;
    private final CompletionsUsage usage;
    private final List<StreamingChatChoiceUpdate> choices;

    private StreamingChatCompletionsUpdate(String id, OffsetDateTime created, String model, CompletionsUsage usage, List<StreamingChatChoiceUpdate> choices) {
        this.id = id;
        this.created = created == null ? 0L : created.toEpochSecond();
        this.model = model;
        this.usage = usage;
        this.choices = choices;
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreated() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    public String getModel() {
        return this.model;
    }

    public CompletionsUsage getUsage() {
        return this.usage;
    }

    public List<StreamingChatChoiceUpdate> getChoices() {
        return this.choices;
    }

    public StreamingChatChoiceUpdate getChoice() {
        return this.choices.get(0);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created", this.created);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        jsonWriter.writeArrayField("choices", this.choices, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static StreamingChatCompletionsUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (StreamingChatCompletionsUpdate)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime created = null;
            String model = null;
            CompletionsUsage usage = null;
            List choices = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created".equals(fieldName)) {
                    created = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = CompletionsUsage.fromJson(reader);
                    continue;
                }
                if ("choices".equals(fieldName)) {
                    choices = reader.readArray(reader1 -> StreamingChatChoiceUpdate.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new StreamingChatCompletionsUpdate(id, created, model, usage, choices);
        });
    }
}

