/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EmbeddingInput
implements JsonSerializable<EmbeddingInput> {
    private final String image;
    private String text;

    public EmbeddingInput(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    public EmbeddingInput setText(String text) {
        this.text = text;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingInput fromJson(JsonReader jsonReader) throws IOException {
        return (EmbeddingInput)jsonReader.readObject(reader -> {
            String image = null;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    image = reader.getString();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            EmbeddingInput deserializedEmbeddingInput = new EmbeddingInput(image);
            deserializedEmbeddingInput.text = text;
            return deserializedEmbeddingInput;
        });
    }
}

