/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.ai.inference.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatRequestToolMessage
extends ChatRequestMessage {
    private ChatRole role = ChatRole.TOOL;
    private String content;
    private final String toolCallId;

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tool_call_id", this.toolCallId);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("content", this.content);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestToolMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestToolMessage)jsonReader.readObject(reader -> {
            String toolCallId = null;
            ChatRole role = ChatRole.TOOL;
            String content = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tool_call_id".equals(fieldName)) {
                    toolCallId = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestToolMessage deserializedChatRequestToolMessage = new ChatRequestToolMessage(toolCallId).setContent(content);
            deserializedChatRequestToolMessage.role = role;
            return deserializedChatRequestToolMessage;
        });
    }

    public ChatRequestToolMessage(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    public ChatRequestToolMessage setContent(String content) {
        this.content = content;
        return this;
    }
}

