/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.ai.inference.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatRequestDeveloperMessage
extends ChatRequestMessage {
    private ChatRole role = ChatRole.DEVELOPER;
    private final String content;

    public ChatRequestDeveloperMessage(String content) {
        this.content = content;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestDeveloperMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestDeveloperMessage)jsonReader.readObject(reader -> {
            String content = null;
            ChatRole role = ChatRole.DEVELOPER;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestDeveloperMessage deserializedChatRequestDeveloperMessage = new ChatRequestDeveloperMessage(content);
            deserializedChatRequestDeveloperMessage.role = role;
            return deserializedChatRequestDeveloperMessage;
        });
    }
}

