/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ChatMessageContentItem;
import com.azure.ai.inference.models.ChatMessageImageUrl;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;

public final class ChatMessageImageContentItem
extends ChatMessageContentItem {
    private String type = "image_url";
    private final ChatMessageImageUrl imageUrl;

    public ChatMessageImageContentItem(ChatMessageImageUrl imageUrl) {
        this.imageUrl = imageUrl;
    }

    public ChatMessageImageContentItem(Path filePath, String imageFormat) {
        try {
            byte[] bytes = Files.readAllBytes(filePath);
            String encodedFile = new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
            String urlTemplate = "data:image/%s;base64,%s";
            this.imageUrl = new ChatMessageImageUrl(String.format(urlTemplate, imageFormat, encodedFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Local file not found.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public ChatMessageImageUrl getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_url", (JsonSerializable)this.imageUrl);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageImageContentItem fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessageImageContentItem)jsonReader.readObject(reader -> {
            ChatMessageImageUrl imageUrl = null;
            String type = "image_url";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_url".equals(fieldName)) {
                    imageUrl = ChatMessageImageUrl.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatMessageImageContentItem deserializedChatMessageImageContentItem = new ChatMessageImageContentItem(imageUrl);
            deserializedChatMessageImageContentItem.type = type;
            return deserializedChatMessageImageContentItem;
        });
    }
}

