/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.implementation.accesshelpers.ChatCompletionsOptionsAccessHelper;
import com.azure.ai.inference.models.ChatCompletionsResponseFormat;
import com.azure.ai.inference.models.ChatCompletionsResponseFormatJsonSchema;
import com.azure.ai.inference.models.ChatCompletionsResponseFormatJsonSchemaDefinition;
import com.azure.ai.inference.models.ChatCompletionsToolDefinition;
import com.azure.ai.inference.models.ChatRequestMessage;
import com.azure.ai.inference.models.ExtraParameters;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ChatCompletionsOptions
implements JsonSerializable<ChatCompletionsOptions> {
    private final List<ChatRequestMessage> messages;
    private Double frequencyPenalty;
    private Boolean stream;
    private Double presencePenalty;
    private Double temperature;
    private Double topP;
    private Integer maxTokens;
    private ChatCompletionsResponseFormat responseFormat;
    private List<String> stop;
    private List<ChatCompletionsToolDefinition> tools;
    private BinaryData toolChoice;
    private Long seed;
    private String model;
    private ExtraParameters extraParams;
    private Map<String, BinaryData> additionalProperties;

    public ChatCompletionsOptions(List<ChatRequestMessage> messages) {
        this.messages = messages;
    }

    public List<ChatRequestMessage> getMessages() {
        return this.messages;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public ChatCompletionsOptions setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    private ChatCompletionsOptions setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public ChatCompletionsOptions setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public ChatCompletionsOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public ChatCompletionsOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public ChatCompletionsOptions setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public ChatCompletionsResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public ChatCompletionsOptions setResponseFormat(ChatCompletionsResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public ChatCompletionsOptions setJsonFormat(String name, Map<String, BinaryData> jsonSchema) {
        this.responseFormat = new ChatCompletionsResponseFormatJsonSchema(new ChatCompletionsResponseFormatJsonSchemaDefinition(name, jsonSchema));
        return this;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public ChatCompletionsOptions setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public List<ChatCompletionsToolDefinition> getTools() {
        return this.tools;
    }

    public ChatCompletionsOptions setTools(List<ChatCompletionsToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    public ChatCompletionsOptions setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    public Long getSeed() {
        return this.seed;
    }

    public ChatCompletionsOptions setSeed(Long seed) {
        this.seed = seed;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public ChatCompletionsOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public ExtraParameters getExtraParams() {
        return this.extraParams;
    }

    public ChatCompletionsOptions setExtraParams(ExtraParameters extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, JsonWriter::writeJson);
        jsonWriter.writeNumberField("max_tokens", (Number)this.maxTokens);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeArrayField("stop", this.stop, JsonWriter::writeString);
        jsonWriter.writeNumberField("presence_penalty", (Number)this.presencePenalty);
        jsonWriter.writeNumberField("frequency_penalty", (Number)this.frequencyPenalty);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeNumberField("seed", (Number)this.seed);
        jsonWriter.writeJsonField("response_format", (JsonSerializable)this.responseFormat);
        jsonWriter.writeArrayField("tools", this.tools, JsonWriter::writeJson);
        if (this.toolChoice != null) {
            jsonWriter.writeRawField("tool_choice", this.toolChoice.toString());
        }
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletionsOptions fromJson(JsonReader jsonReader) throws IOException {
        return (ChatCompletionsOptions)jsonReader.readObject(reader -> {
            List messages = null;
            Double frequencyPenalty = null;
            Boolean stream = null;
            Double presencePenalty = null;
            Double temperature = null;
            Double topP = null;
            Integer maxTokens = null;
            ChatCompletionsResponseFormat responseFormat = null;
            List stop = null;
            List tools = null;
            BinaryData toolChoice = null;
            Long seed = null;
            String model = null;
            LinkedHashMap<String, BinaryData> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    messages = reader.readArray(reader1 -> ChatRequestMessage.fromJson(reader1));
                    continue;
                }
                if ("frequency_penalty".equals(fieldName)) {
                    frequencyPenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("presence_penalty".equals(fieldName)) {
                    presencePenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max_tokens".equals(fieldName)) {
                    maxTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = ChatCompletionsResponseFormat.fromJson(reader);
                    continue;
                }
                if ("stop".equals(fieldName)) {
                    stop = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ChatCompletionsToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("seed".equals(fieldName)) {
                    seed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, BinaryData>();
                }
                additionalProperties.put(fieldName, (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
            }
            ChatCompletionsOptions deserializedChatCompletionsOptions = new ChatCompletionsOptions(messages);
            deserializedChatCompletionsOptions.frequencyPenalty = frequencyPenalty;
            deserializedChatCompletionsOptions.stream = stream;
            deserializedChatCompletionsOptions.presencePenalty = presencePenalty;
            deserializedChatCompletionsOptions.temperature = temperature;
            deserializedChatCompletionsOptions.topP = topP;
            deserializedChatCompletionsOptions.maxTokens = maxTokens;
            deserializedChatCompletionsOptions.responseFormat = responseFormat;
            deserializedChatCompletionsOptions.stop = stop;
            deserializedChatCompletionsOptions.tools = tools;
            deserializedChatCompletionsOptions.toolChoice = toolChoice;
            deserializedChatCompletionsOptions.seed = seed;
            deserializedChatCompletionsOptions.model = model;
            deserializedChatCompletionsOptions.additionalProperties = additionalProperties;
            return deserializedChatCompletionsOptions;
        });
    }

    public Map<String, BinaryData> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ChatCompletionsOptions setAdditionalProperties(Map<String, BinaryData> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    static {
        ChatCompletionsOptionsAccessHelper.setAccessor(new ChatCompletionsOptionsAccessHelper.ChatCompletionsOptionsAccessor(){

            @Override
            public void setStream(ChatCompletionsOptions options, boolean stream) {
                options.setStream(stream);
            }
        });
    }
}

