/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.implementation.models;

import com.azure.ai.inference.models.EmbeddingEncodingFormat;
import com.azure.ai.inference.models.EmbeddingInputType;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class EmbedRequest
implements JsonSerializable<EmbedRequest> {
    private final List<String> input;
    private Integer dimensions;
    private EmbeddingEncodingFormat encodingFormat;
    private EmbeddingInputType inputType;
    private String model;
    private Map<String, BinaryData> additionalProperties;

    public EmbedRequest(List<String> input) {
        this.input = input;
    }

    public List<String> getInput() {
        return this.input;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public EmbedRequest setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public EmbeddingEncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    public EmbedRequest setEncodingFormat(EmbeddingEncodingFormat encodingFormat) {
        this.encodingFormat = encodingFormat;
        return this;
    }

    public EmbeddingInputType getInputType() {
        return this.inputType;
    }

    public EmbedRequest setInputType(EmbeddingInputType inputType) {
        this.inputType = inputType;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public EmbedRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public Map<String, BinaryData> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public EmbedRequest setAdditionalProperties(Map<String, BinaryData> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("input", this.input, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("dimensions", (Number)this.dimensions);
        jsonWriter.writeStringField("encoding_format", this.encodingFormat == null ? null : this.encodingFormat.toString());
        jsonWriter.writeStringField("input_type", this.inputType == null ? null : this.inputType.toString());
        jsonWriter.writeStringField("model", this.model);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, BinaryData> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeFieldName(additionalProperty.getKey());
                if (additionalProperty.getValue() == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                additionalProperty.getValue().writeTo(jsonWriter);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static EmbedRequest fromJson(JsonReader jsonReader) throws IOException {
        return (EmbedRequest)jsonReader.readObject(reader -> {
            List input = null;
            Integer dimensions = null;
            EmbeddingEncodingFormat encodingFormat = null;
            EmbeddingInputType inputType = null;
            String model = null;
            LinkedHashMap<String, BinaryData> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    input = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    dimensions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("encoding_format".equals(fieldName)) {
                    encodingFormat = EmbeddingEncodingFormat.fromString(reader.getString());
                    continue;
                }
                if ("input_type".equals(fieldName)) {
                    inputType = EmbeddingInputType.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, BinaryData>();
                }
                additionalProperties.put(fieldName, (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
            }
            EmbedRequest deserializedEmbedRequest = new EmbedRequest(input);
            deserializedEmbedRequest.dimensions = dimensions;
            deserializedEmbedRequest.encodingFormat = encodingFormat;
            deserializedEmbedRequest.inputType = inputType;
            deserializedEmbedRequest.model = model;
            deserializedEmbedRequest.additionalProperties = additionalProperties;
            return deserializedEmbedRequest;
        });
    }
}

