// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;

/**
 * Represents an image with optional text.
 */
@Fluent
public final class ImageEmbeddingInput implements JsonSerializable<ImageEmbeddingInput> {

    /*
     * The input image encoded in base64 string as a data URL. Example: `data:image/{format};base64,{data}`.
     */
    @Generated
    private final String image;

    /*
     * Optional. The text input to feed into the model (like DINO, CLIP).
     * Returns a 422 error if the model doesn't support the value or parameter.
     */
    @Generated
    private String text;

    /**
     * Creates an instance of ImageEmbeddingInput class.
     *
     * @param filePath path to the imageFile.
     * @param imageFormatType format of the image
     * @throws RuntimeException If an error occurs while reading the file or file not found.
     */
    public ImageEmbeddingInput(Path filePath, String imageFormatType) {
        try {
            byte[] bytes = Files.readAllBytes(filePath);
            String encodedFile = new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
            String urlTemplate = "data:image/%s;base64,%s";
            this.image = String.format(urlTemplate, imageFormatType, encodedFile);
        } catch (FileNotFoundException e) {
            throw new RuntimeException("Local file not found.", e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Creates an instance of ImageEmbeddingInput class.
     *
     * @param image the image value to set.
     */
    @Generated
    public ImageEmbeddingInput(String image) {
        this.image = image;
    }

    /**
     * Get the image property: The input image encoded in base64 string as a data URL. Example:
     * `data:image/{format};base64,{data}`.
     *
     * @return the image value.
     */
    @Generated
    public String getImage() {
        return this.image;
    }

    /**
     * Get the text property: Optional. The text input to feed into the model (like DINO, CLIP).
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: Optional. The text input to feed into the model (like DINO, CLIP).
     * Returns a 422 error if the model doesn't support the value or parameter.
     *
     * @param text the text value to set.
     * @return the ImageEmbeddingInput object itself.
     */
    @Generated
    public ImageEmbeddingInput setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageEmbeddingInput from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageEmbeddingInput if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImageEmbeddingInput.
     */
    @Generated
    public static ImageEmbeddingInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String image = null;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    image = reader.getString();
                } else if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ImageEmbeddingInput deserializedImageEmbeddingInput = new ImageEmbeddingInput(image);
            deserializedImageEmbeddingInput.text = text;
            return deserializedImageEmbeddingInput;
        });
    }
}
