// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.TypeReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Representation of a single embeddings relatedness comparison.
 */
@Immutable
public final class EmbeddingItem implements JsonSerializable<EmbeddingItem> {

    /*
     * List of embedding values for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input. Or a base64 encoded string of the embedding vector.
     */
    @Generated
    private final BinaryData embedding;

    /*
     * Index of the prompt to which the EmbeddingItem corresponds.
     */
    @Generated
    private final int index;

    /**
     * Creates an instance of EmbeddingItem class.
     *
     * @param embedding the embedding value to set.
     * @param index the index value to set.
     */
    @Generated
    private EmbeddingItem(BinaryData embedding, int index) {
        this.embedding = embedding;
        this.index = index;
    }

    /**
     * Get the embedding property: List of embedding values for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input. Or a base64 encoded string of the embedding vector.
     *
     * @return the embedding value.
     */
    @Generated
    public BinaryData getEmbedding() {
        return this.embedding;
    }

    /**
     * Get the embedding property: List of embedding values for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input. Or a base64 encoded string of the embedding vector.
     *
     * @return the embeddings as a list of floats.
     */
    public List<Float> getEmbeddingList() {
        return this.embedding.toObject(new TypeReference<List<Float>>() {
        });
    }

    /**
     * Get the index property: Index of the prompt to which the EmbeddingItem corresponds.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeFieldName("embedding");
        this.embedding.writeTo(jsonWriter);
        jsonWriter.writeIntField("index", this.index);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmbeddingItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmbeddingItem if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmbeddingItem.
     */
    @Generated
    public static EmbeddingItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BinaryData embedding = null;
            int index = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("embedding".equals(fieldName)) {
                    embedding = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }
            return new EmbeddingItem(embedding, index);
        });
    }
}
