// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents the input types used for embedding search.
 */
public final class EmbeddingInputType extends ExpandableStringEnum<EmbeddingInputType> {

    /**
     * Indicates the input is a general text input.
     */
    @Generated
    public static final EmbeddingInputType TEXT = fromString("text");

    /**
     * Indicates the input represents a search query to find the most relevant documents in your vector database.
     */
    @Generated
    public static final EmbeddingInputType QUERY = fromString("query");

    /**
     * Indicates the input represents a document that is stored in a vector database.
     */
    @Generated
    public static final EmbeddingInputType DOCUMENT = fromString("document");

    /**
     * Creates a new instance of EmbeddingInputType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public EmbeddingInputType() {
    }

    /**
     * Creates or finds a EmbeddingInputType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding EmbeddingInputType.
     */
    @Generated
    public static EmbeddingInputType fromString(String name) {
        return fromString(name, EmbeddingInputType.class);
    }

    /**
     * Gets known EmbeddingInputType values.
     *
     * @return known EmbeddingInputType values.
     */
    @Generated
    public static Collection<EmbeddingInputType> values() {
        return values(EmbeddingInputType.class);
    }
}
