// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The format of the embeddings result.
 * Returns a 422 error if the model doesn't support the value or parameter.
 */
public final class EmbeddingEncodingFormat extends ExpandableStringEnum<EmbeddingEncodingFormat> {

    /**
     * Base64.
     */
    @Generated
    public static final EmbeddingEncodingFormat BASE64 = fromString("base64");

    /**
     * Binary.
     */
    @Generated
    public static final EmbeddingEncodingFormat BINARY = fromString("binary");

    /**
     * Floating point.
     */
    @Generated
    public static final EmbeddingEncodingFormat FLOAT = fromString("float");

    /**
     * Signed 8-bit integer.
     */
    @Generated
    public static final EmbeddingEncodingFormat INT8 = fromString("int8");

    /**
     * ubinary.
     */
    @Generated
    public static final EmbeddingEncodingFormat UBINARY = fromString("ubinary");

    /**
     * Unsigned 8-bit integer.
     */
    @Generated
    public static final EmbeddingEncodingFormat UINT8 = fromString("uint8");

    /**
     * Creates a new instance of EmbeddingEncodingFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public EmbeddingEncodingFormat() {
    }

    /**
     * Creates or finds a EmbeddingEncodingFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding EmbeddingEncodingFormat.
     */
    @Generated
    public static EmbeddingEncodingFormat fromString(String name) {
        return fromString(name, EmbeddingEncodingFormat.class);
    }

    /**
     * Gets known EmbeddingEncodingFormat values.
     *
     * @return known EmbeddingEncodingFormat values.
     */
    @Generated
    public static Collection<EmbeddingEncodingFormat> values() {
        return values(EmbeddingEncodingFormat.class);
    }
}
