// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

/**
 * A request chat message representing user input to the assistant.
 */
@Immutable
public final class ChatRequestUserMessage extends ChatRequestMessage {

    /*
     * The chat role associated with this message.
     */
    @Generated
    private ChatRole role = ChatRole.USER;

    /*
     * The contents of the user message, with available input types varying by selected model.
     */
    @Generated
    private final BinaryData content;

    /**
     * Creates an instance of ChatRequestUserMessage class.
     *
     * @param content the content value to set.
     */
    @Generated
    public ChatRequestUserMessage(BinaryData content) {
        this.content = content;
    }

    /**
     * Creates an instance of ChatRequestUserMessage class.
     *
     * @param content the string content value to set.
     */
    public ChatRequestUserMessage(String content) {
        this.content = BinaryData.fromObject(content);
    }

    /**
     * Get the role property: The chat role associated with this message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The contents of the user message, with available input types varying by selected model.
     *
     * @return the content value.
     */
    @Generated
    public BinaryData getContent() {
        return this.content;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeFieldName("content");
        this.content.writeTo(jsonWriter);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatRequestUserMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatRequestUserMessage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatRequestUserMessage.
     */
    @Generated
    public static ChatRequestUserMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BinaryData content = null;
            ChatRole role = ChatRole.USER;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ChatRequestUserMessage deserializedChatRequestUserMessage = new ChatRequestUserMessage(content);
            deserializedChatRequestUserMessage.role = role;
            return deserializedChatRequestUserMessage;
        });
    }

    /**
     * Creates an instance of ChatRequestUserMessage class.
     *
     * @param content the content value to set.
     * @return An instance of ChatRequestUserMessage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws RuntimeException If the deserialized JSON object was missing any required properties.
     */
    public static ChatRequestUserMessage fromString(String content) {
        String jsonPrompt = "{" + "\"content\":\"%s\"" + "}";
        String contentString = String.format(jsonPrompt, content);
        try {
            return ChatRequestUserMessage.fromJson(JsonProviders.createReader(new StringReader(contentString)));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Creates an instance of ChatRequestUserMessage class.
     *
     * @param contentItems An array of content items to include in the message.
     * @return An instance of ChatRequestUserMessage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws RuntimeException If the deserialized JSON object was missing any required properties.
     */
    public static ChatRequestUserMessage fromContentItems(List<ChatMessageContentItem> contentItems) {
        if (contentItems == null || contentItems.isEmpty()) {
            throw new RuntimeException("Content items cannot be null or empty.");
        }
        StringBuilder jsonPrompt = new StringBuilder("{\"content\":[");
        for (ChatMessageContentItem item : contentItems) {
            if (item instanceof ChatMessageTextContentItem) {
                ChatMessageTextContentItem textItem = (ChatMessageTextContentItem) item;
                String textPrompt = "{\"type\": \"text\", \"text\":\"%s\"}";
                jsonPrompt.append(String.format(textPrompt, textItem.getText()));
            } else if (item instanceof ChatMessageImageContentItem) {
                ChatMessageImageContentItem imageItem = (ChatMessageImageContentItem) item;
                String imageUrlPrompt = "{\"type\": \"image_url\", \"image_url\":{ \"url\": \"%s\"}}";
                jsonPrompt.append(String.format(imageUrlPrompt, imageItem.getImageUrl().getUrl()));
            }
            jsonPrompt.append(",");
        }
        jsonPrompt = new StringBuilder(jsonPrompt.substring(0, jsonPrompt.length() - 1));
        jsonPrompt.append("]}");
        try {
            return ChatRequestUserMessage.fromJson(JsonProviders.createReader(new StringReader(jsonPrompt.toString())));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
