// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A request chat message representing response or action from the assistant.
 */
@Fluent
public final class ChatRequestAssistantMessage extends ChatRequestMessage {

    /*
     * The chat role associated with this message.
     */
    @Generated
    private ChatRole role = ChatRole.ASSISTANT;

    /*
     * The content of the message.
     */
    @Generated
    private String content;

    /*
     * The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
     * completions request to resolve as configured.
     */
    @Generated
    private List<ChatCompletionsToolCall> toolCalls;

    /**
     * Creates an instance of ChatRequestAssistantMessage class.
     */
    public ChatRequestAssistantMessage() {
    }

    /**
     * Creates an instance of ChatRequestAssistantMessage class.
     *
     * @param content the content value to set.
     */
    public ChatRequestAssistantMessage(String content) {
        this.content = content;
    }

    /**
     * Get the role property: The chat role associated with this message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The content of the message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Set the content property: The content of the message.
     *
     * @param content the content value to set.
     * @return the ChatRequestAssistantMessage object itself.
     */
    @Generated
    public ChatRequestAssistantMessage setContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the toolCalls property: The tool calls that must be resolved and have their outputs appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @return the toolCalls value.
     */
    @Generated
    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    /**
     * Set the toolCalls property: The tool calls that must be resolved and have their outputs appended to subsequent
     * input messages for the chat
     * completions request to resolve as configured.
     *
     * @param toolCalls the toolCalls value to set.
     * @return the ChatRequestAssistantMessage object itself.
     */
    @Generated
    public ChatRequestAssistantMessage setToolCalls(List<ChatCompletionsToolCall> toolCalls) {
        this.toolCalls = toolCalls;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatRequestAssistantMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatRequestAssistantMessage if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatRequestAssistantMessage.
     */
    @Generated
    public static ChatRequestAssistantMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatRequestAssistantMessage deserializedChatRequestAssistantMessage = new ChatRequestAssistantMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedChatRequestAssistantMessage.role = ChatRole.fromString(reader.getString());
                } else if ("content".equals(fieldName)) {
                    deserializedChatRequestAssistantMessage.content = reader.getString();
                } else if ("tool_calls".equals(fieldName)) {
                    List<ChatCompletionsToolCall> toolCalls
                        = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                    deserializedChatRequestAssistantMessage.toolCalls = toolCalls;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedChatRequestAssistantMessage;
        });
    }
}
