// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Defines the response format for chat completions as JSON with a given schema. The AI model
 * will need to adhere to this schema when generating completions.
 */
@Fluent
public final class ChatCompletionsResponseFormatJsonSchemaDefinition
    implements JsonSerializable<ChatCompletionsResponseFormatJsonSchemaDefinition> {

    /*
     * A name that labels this JSON schema. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum
     * length of 64.
     */
    @Generated
    private final String name;

    /*
     * The definition of the JSON schema. See https://json-schema.org/overview/what-is-jsonschema.
     * Note that AI models usually only support a subset of the keywords defined by JSON schema. Consult your AI model
     * documentation
     * to determine what is supported.
     */
    @Generated
    private final Map<String, BinaryData> schema;

    /*
     * A description of the response format, used by the AI model to determine how to generate responses in this format.
     */
    @Generated
    private String description;

    /*
     * If set to true, the service will error out if the provided JSON schema contains keywords
     * not supported by the AI model. An example of such keyword may be `maxLength` for JSON type `string`.
     * If false, and the provided JSON schema contains keywords not supported
     * by the AI model, the AI model will not error out. Instead it will ignore the unsupported keywords.
     */
    @Generated
    private Boolean strict;

    /**
     * Creates an instance of ChatCompletionsResponseFormatJsonSchemaDefinition class.
     *
     * @param name the name value to set.
     * @param schema the schema value to set.
     */
    @Generated
    public ChatCompletionsResponseFormatJsonSchemaDefinition(String name, Map<String, BinaryData> schema) {
        this.name = name;
        this.schema = schema;
    }

    /**
     * Get the name property: A name that labels this JSON schema. Must be a-z, A-Z, 0-9, or contain underscores and
     * dashes, with a maximum length of 64.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the schema property: The definition of the JSON schema. See
     * https://json-schema.org/overview/what-is-jsonschema.
     * Note that AI models usually only support a subset of the keywords defined by JSON schema. Consult your AI model
     * documentation
     * to determine what is supported.
     *
     * @return the schema value.
     */
    @Generated
    public Map<String, BinaryData> getSchema() {
        return this.schema;
    }

    /**
     * Get the description property: A description of the response format, used by the AI model to determine how to
     * generate responses in this format.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: A description of the response format, used by the AI model to determine how to
     * generate responses in this format.
     *
     * @param description the description value to set.
     * @return the ChatCompletionsResponseFormatJsonSchemaDefinition object itself.
     */
    @Generated
    public ChatCompletionsResponseFormatJsonSchemaDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the strict property: If set to true, the service will error out if the provided JSON schema contains keywords
     * not supported by the AI model. An example of such keyword may be `maxLength` for JSON type `string`.
     * If false, and the provided JSON schema contains keywords not supported
     * by the AI model, the AI model will not error out. Instead it will ignore the unsupported keywords.
     *
     * @return the strict value.
     */
    @Generated
    public Boolean isStrict() {
        return this.strict;
    }

    /**
     * Set the strict property: If set to true, the service will error out if the provided JSON schema contains keywords
     * not supported by the AI model. An example of such keyword may be `maxLength` for JSON type `string`.
     * If false, and the provided JSON schema contains keywords not supported
     * by the AI model, the AI model will not error out. Instead it will ignore the unsupported keywords.
     *
     * @param strict the strict value to set.
     * @return the ChatCompletionsResponseFormatJsonSchemaDefinition object itself.
     */
    @Generated
    public ChatCompletionsResponseFormatJsonSchemaDefinition setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("schema", this.schema,
            (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("strict", this.strict);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsResponseFormatJsonSchemaDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsResponseFormatJsonSchemaDefinition if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsResponseFormatJsonSchemaDefinition.
     */
    @Generated
    public static ChatCompletionsResponseFormatJsonSchemaDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            Map<String, BinaryData> schema = null;
            String description = null;
            Boolean strict = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("schema".equals(fieldName)) {
                    schema = reader.readMap(reader1 -> reader1
                        .getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped())));
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("strict".equals(fieldName)) {
                    strict = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            ChatCompletionsResponseFormatJsonSchemaDefinition deserializedChatCompletionsResponseFormatJsonSchemaDefinition
                = new ChatCompletionsResponseFormatJsonSchemaDefinition(name, schema);
            deserializedChatCompletionsResponseFormatJsonSchemaDefinition.description = description;
            deserializedChatCompletionsResponseFormatJsonSchemaDefinition.strict = strict;
            return deserializedChatCompletionsResponseFormatJsonSchemaDefinition;
        });
    }
}
