// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A response format for Chat Completions that restricts responses to emitting valid JSON objects, with a
 * JSON schema specified by the caller.
 */
@Immutable
public final class ChatCompletionsResponseFormatJsonSchema extends ChatCompletionsResponseFormat {

    /*
     * The response format type to use for chat completions.
     */
    @Generated
    private String type = "json_schema";

    /*
     * The definition of the required JSON schema in the response, and associated metadata.
     */
    @Generated
    private final ChatCompletionsResponseFormatJsonSchemaDefinition jsonSchema;

    /**
     * Creates an instance of ChatCompletionsResponseFormatJsonSchema class.
     *
     * @param jsonSchema the jsonSchema value to set.
     */
    @Generated
    public ChatCompletionsResponseFormatJsonSchema(ChatCompletionsResponseFormatJsonSchemaDefinition jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    /**
     * Get the type property: The response format type to use for chat completions.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the jsonSchema property: The definition of the required JSON schema in the response, and associated metadata.
     *
     * @return the jsonSchema value.
     */
    @Generated
    public ChatCompletionsResponseFormatJsonSchemaDefinition getJsonSchema() {
        return this.jsonSchema;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("json_schema", this.jsonSchema);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsResponseFormatJsonSchema from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsResponseFormatJsonSchema if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsResponseFormatJsonSchema.
     */
    @Generated
    public static ChatCompletionsResponseFormatJsonSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsResponseFormatJsonSchemaDefinition jsonSchema = null;
            String type = "json_schema";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("json_schema".equals(fieldName)) {
                    jsonSchema = ChatCompletionsResponseFormatJsonSchemaDefinition.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatCompletionsResponseFormatJsonSchema deserializedChatCompletionsResponseFormatJsonSchema
                = new ChatCompletionsResponseFormatJsonSchema(jsonSchema);
            deserializedChatCompletionsResponseFormatJsonSchema.type = type;
            return deserializedChatCompletionsResponseFormatJsonSchema;
        });
    }
}
