// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.inference.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A response format for Chat Completions that restricts responses to emitting valid JSON objects.
 * Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
 * via a system or user message.
 */
@Immutable
public final class ChatCompletionsResponseFormatJsonObject extends ChatCompletionsResponseFormat {

    /*
     * The response format type to use for chat completions.
     */
    @Generated
    private String type = "json_object";

    /**
     * Creates an instance of ChatCompletionsResponseFormatJsonObject class.
     */
    @Generated
    public ChatCompletionsResponseFormatJsonObject() {
    }

    /**
     * Get the type property: The response format type to use for chat completions.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsResponseFormatJsonObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsResponseFormatJsonObject if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionsResponseFormatJsonObject.
     */
    @Generated
    public static ChatCompletionsResponseFormatJsonObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsResponseFormatJsonObject deserializedChatCompletionsResponseFormatJsonObject
                = new ChatCompletionsResponseFormatJsonObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedChatCompletionsResponseFormatJsonObject.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedChatCompletionsResponseFormatJsonObject;
        });
    }
}
