/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentBarcodeKind;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentBarcode
implements JsonSerializable<DocumentBarcode> {
    private final DocumentBarcodeKind kind;
    private final String value;
    private List<Double> polygon;
    private final DocumentSpan span;
    private final double confidence;

    private DocumentBarcode(DocumentBarcodeKind kind, String value, DocumentSpan span, double confidence) {
        this.kind = kind;
        this.value = value;
        this.span = span;
        this.confidence = confidence;
    }

    public DocumentBarcodeKind getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    public List<Double> getPolygon() {
        return this.polygon;
    }

    public DocumentSpan getSpan() {
        return this.span;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeJsonField("span", (JsonSerializable)this.span);
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentBarcode fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentBarcode)jsonReader.readObject(reader -> {
            DocumentBarcodeKind kind = null;
            String value = null;
            DocumentSpan span = null;
            double confidence = 0.0;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    kind = DocumentBarcodeKind.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = reader.getString();
                    continue;
                }
                if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentBarcode deserializedDocumentBarcode = new DocumentBarcode(kind, value, span, confidence);
            deserializedDocumentBarcode.polygon = polygon;
            return deserializedDocumentBarcode;
        });
    }
}

