// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Semantic role of the paragraph.
 */
public final class ParagraphRole extends ExpandableStringEnum<ParagraphRole> {

    /**
     * Text near the top edge of the page.
     */
    @Generated
    public static final ParagraphRole PAGE_HEADER = fromString("pageHeader");

    /**
     * Text near the bottom edge of the page.
     */
    @Generated
    public static final ParagraphRole PAGE_FOOTER = fromString("pageFooter");

    /**
     * Page number.
     */
    @Generated
    public static final ParagraphRole PAGE_NUMBER = fromString("pageNumber");

    /**
     * Top-level title describing the entire document.
     */
    @Generated
    public static final ParagraphRole TITLE = fromString("title");

    /**
     * Sub heading describing a section of the document.
     */
    @Generated
    public static final ParagraphRole SECTION_HEADING = fromString("sectionHeading");

    /**
     * A note usually placed after the main content on a page.
     */
    @Generated
    public static final ParagraphRole FOOTNOTE = fromString("footnote");

    /**
     * A block of formulas, often with shared alignment.
     */
    @Generated
    public static final ParagraphRole FORMULA_BLOCK = fromString("formulaBlock");

    /**
     * Creates a new instance of ParagraphRole value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ParagraphRole() {
    }

    /**
     * Creates or finds a ParagraphRole from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ParagraphRole.
     */
    @Generated
    public static ParagraphRole fromString(String name) {
        return fromString(name, ParagraphRole.class);
    }

    /**
     * Gets known ParagraphRole values.
     *
     * @return known ParagraphRole values.
     */
    @Generated
    public static Collection<ParagraphRole> values() {
        return values(ParagraphRole.class);
    }
}
