// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Document type info.
 */
@Fluent
public final class DocumentTypeDetails implements JsonSerializable<DocumentTypeDetails> {

    /*
     * Document model description.
     */
    @Generated
    private String description;

    /*
     * Custom document model build mode.
     */
    @Generated
    private DocumentBuildMode buildMode;

    /*
     * Description of the document semantic schema using a JSON Schema style syntax.
     */
    @Generated
    private Map<String, DocumentFieldSchema> fieldSchema;

    /*
     * Estimated confidence for each field.
     */
    @Generated
    private Map<String, Double> fieldConfidence;

    /*
     * Document model to use for analyzing documents with specified type.
     */
    @Generated
    private String modelId;

    /*
     * Only perform analysis if docType confidence is above threshold.
     */
    @Generated
    private Double confidenceThreshold;

    /*
     * List of optional analysis features.
     */
    @Generated
    private List<DocumentAnalysisFeature> features;

    /*
     * List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber"
     */
    @Generated
    private List<String> queryFields;

    /*
     * Maximum number of documents of specified type to analyze. Default=all.
     */
    @Generated
    private Integer maxDocumentsToAnalyze;

    /**
     * Creates an instance of DocumentTypeDetails class.
     */
    @Generated
    public DocumentTypeDetails() {
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     *
     * @param description the description value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     *
     * @return the buildMode value.
     */
    @Generated
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Set the buildMode property: Custom document model build mode.
     *
     * @param buildMode the buildMode value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setBuildMode(DocumentBuildMode buildMode) {
        this.buildMode = buildMode;
        return this;
    }

    /**
     * Get the fieldSchema property: Description of the document semantic schema using a JSON Schema style syntax.
     *
     * @return the fieldSchema value.
     */
    @Generated
    public Map<String, DocumentFieldSchema> getFieldSchema() {
        return this.fieldSchema;
    }

    /**
     * Set the fieldSchema property: Description of the document semantic schema using a JSON Schema style syntax.
     *
     * @param fieldSchema the fieldSchema value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setFieldSchema(Map<String, DocumentFieldSchema> fieldSchema) {
        this.fieldSchema = fieldSchema;
        return this;
    }

    /**
     * Get the fieldConfidence property: Estimated confidence for each field.
     *
     * @return the fieldConfidence value.
     */
    @Generated
    public Map<String, Double> getFieldConfidence() {
        return this.fieldConfidence;
    }

    /**
     * Set the fieldConfidence property: Estimated confidence for each field.
     *
     * @param fieldConfidence the fieldConfidence value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setFieldConfidence(Map<String, Double> fieldConfidence) {
        this.fieldConfidence = fieldConfidence;
        return this;
    }

    /**
     * Get the modelId property: Document model to use for analyzing documents with specified type.
     *
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Set the modelId property: Document model to use for analyzing documents with specified type.
     *
     * @param modelId the modelId value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    /**
     * Get the confidenceThreshold property: Only perform analysis if docType confidence is above threshold.
     *
     * @return the confidenceThreshold value.
     */
    @Generated
    public Double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    /**
     * Set the confidenceThreshold property: Only perform analysis if docType confidence is above threshold.
     *
     * @param confidenceThreshold the confidenceThreshold value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setConfidenceThreshold(Double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
        return this;
    }

    /**
     * Get the features property: List of optional analysis features.
     *
     * @return the features value.
     */
    @Generated
    public List<DocumentAnalysisFeature> getFeatures() {
        return this.features;
    }

    /**
     * Set the features property: List of optional analysis features.
     *
     * @param features the features value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setFeatures(List<DocumentAnalysisFeature> features) {
        this.features = features;
        return this;
    }

    /**
     * Get the queryFields property: List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     *
     * @return the queryFields value.
     */
    @Generated
    public List<String> getQueryFields() {
        return this.queryFields;
    }

    /**
     * Set the queryFields property: List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     *
     * @param queryFields the queryFields value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setQueryFields(List<String> queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    /**
     * Get the maxDocumentsToAnalyze property: Maximum number of documents of specified type to analyze. Default=all.
     *
     * @return the maxDocumentsToAnalyze value.
     */
    @Generated
    public Integer getMaxDocumentsToAnalyze() {
        return this.maxDocumentsToAnalyze;
    }

    /**
     * Set the maxDocumentsToAnalyze property: Maximum number of documents of specified type to analyze. Default=all.
     *
     * @param maxDocumentsToAnalyze the maxDocumentsToAnalyze value to set.
     * @return the DocumentTypeDetails object itself.
     */
    @Generated
    public DocumentTypeDetails setMaxDocumentsToAnalyze(Integer maxDocumentsToAnalyze) {
        this.maxDocumentsToAnalyze = maxDocumentsToAnalyze;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("buildMode", this.buildMode == null ? null : this.buildMode.toString());
        jsonWriter.writeMapField("fieldSchema", this.fieldSchema, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("fieldConfidence", this.fieldConfidence,
            (writer, element) -> writer.writeDouble(element));
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeNumberField("confidenceThreshold", this.confidenceThreshold);
        jsonWriter.writeArrayField("features", this.features,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("queryFields", this.queryFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxDocumentsToAnalyze", this.maxDocumentsToAnalyze);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentTypeDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentTypeDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DocumentTypeDetails.
     */
    @Generated
    public static DocumentTypeDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentTypeDetails deserializedDocumentTypeDetails = new DocumentTypeDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDocumentTypeDetails.description = reader.getString();
                } else if ("buildMode".equals(fieldName)) {
                    deserializedDocumentTypeDetails.buildMode = DocumentBuildMode.fromString(reader.getString());
                } else if ("fieldSchema".equals(fieldName)) {
                    Map<String, DocumentFieldSchema> fieldSchema
                        = reader.readMap(reader1 -> DocumentFieldSchema.fromJson(reader1));
                    deserializedDocumentTypeDetails.fieldSchema = fieldSchema;
                } else if ("fieldConfidence".equals(fieldName)) {
                    Map<String, Double> fieldConfidence = reader.readMap(reader1 -> reader1.getDouble());
                    deserializedDocumentTypeDetails.fieldConfidence = fieldConfidence;
                } else if ("modelId".equals(fieldName)) {
                    deserializedDocumentTypeDetails.modelId = reader.getString();
                } else if ("confidenceThreshold".equals(fieldName)) {
                    deserializedDocumentTypeDetails.confidenceThreshold = reader.getNullable(JsonReader::getDouble);
                } else if ("features".equals(fieldName)) {
                    List<DocumentAnalysisFeature> features
                        = reader.readArray(reader1 -> DocumentAnalysisFeature.fromString(reader1.getString()));
                    deserializedDocumentTypeDetails.features = features;
                } else if ("queryFields".equals(fieldName)) {
                    List<String> queryFields = reader.readArray(reader1 -> reader1.getString());
                    deserializedDocumentTypeDetails.queryFields = queryFields;
                } else if ("maxDocumentsToAnalyze".equals(fieldName)) {
                    deserializedDocumentTypeDetails.maxDocumentsToAnalyze = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedDocumentTypeDetails;
        });
    }
}
