// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object representing the location and content of a table cell.
 */
@Immutable
public final class DocumentTableCell implements JsonSerializable<DocumentTableCell> {

    /*
     * Table cell kind.
     */
    @Generated
    private DocumentTableCellKind kind;

    /*
     * Row index of the cell.
     */
    @Generated
    private final int rowIndex;

    /*
     * Column index of the cell.
     */
    @Generated
    private final int columnIndex;

    /*
     * Number of rows spanned by this cell.
     */
    @Generated
    private Integer rowSpan;

    /*
     * Number of columns spanned by this cell.
     */
    @Generated
    private Integer columnSpan;

    /*
     * Concatenated content of the table cell in reading order.
     */
    @Generated
    private final String content;

    /*
     * Bounding regions covering the table cell.
     */
    @Generated
    private List<BoundingRegion> boundingRegions;

    /*
     * Location of the table cell in the reading order concatenated content.
     */
    @Generated
    private final List<DocumentSpan> spans;

    /*
     * Child elements of the table cell.
     */
    @Generated
    private List<String> elements;

    /**
     * Creates an instance of DocumentTableCell class.
     *
     * @param rowIndex the rowIndex value to set.
     * @param columnIndex the columnIndex value to set.
     * @param content the content value to set.
     * @param spans the spans value to set.
     */
    @Generated
    private DocumentTableCell(int rowIndex, int columnIndex, String content, List<DocumentSpan> spans) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.content = content;
        this.spans = spans;
    }

    /**
     * Get the kind property: Table cell kind.
     *
     * @return the kind value.
     */
    @Generated
    public DocumentTableCellKind getKind() {
        return this.kind;
    }

    /**
     * Get the rowIndex property: Row index of the cell.
     *
     * @return the rowIndex value.
     */
    @Generated
    public int getRowIndex() {
        return this.rowIndex;
    }

    /**
     * Get the columnIndex property: Column index of the cell.
     *
     * @return the columnIndex value.
     */
    @Generated
    public int getColumnIndex() {
        return this.columnIndex;
    }

    /**
     * Get the rowSpan property: Number of rows spanned by this cell.
     *
     * @return the rowSpan value.
     */
    @Generated
    public Integer getRowSpan() {
        return this.rowSpan;
    }

    /**
     * Get the columnSpan property: Number of columns spanned by this cell.
     *
     * @return the columnSpan value.
     */
    @Generated
    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    /**
     * Get the content property: Concatenated content of the table cell in reading order.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the boundingRegions property: Bounding regions covering the table cell.
     *
     * @return the boundingRegions value.
     */
    @Generated
    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    /**
     * Get the spans property: Location of the table cell in the reading order concatenated content.
     *
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the elements property: Child elements of the table cell.
     *
     * @return the elements value.
     */
    @Generated
    public List<String> getElements() {
        return this.elements;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowIndex", this.rowIndex);
        jsonWriter.writeIntField("columnIndex", this.columnIndex);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("rowSpan", this.rowSpan);
        jsonWriter.writeNumberField("columnSpan", this.columnSpan);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentTableCell from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentTableCell if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentTableCell.
     */
    @Generated
    public static DocumentTableCell fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int rowIndex = 0;
            int columnIndex = 0;
            String content = null;
            List<DocumentSpan> spans = null;
            DocumentTableCellKind kind = null;
            Integer rowSpan = null;
            Integer columnSpan = null;
            List<BoundingRegion> boundingRegions = null;
            List<String> elements = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rowIndex".equals(fieldName)) {
                    rowIndex = reader.getInt();
                } else if ("columnIndex".equals(fieldName)) {
                    columnIndex = reader.getInt();
                } else if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                } else if ("kind".equals(fieldName)) {
                    kind = DocumentTableCellKind.fromString(reader.getString());
                } else if ("rowSpan".equals(fieldName)) {
                    rowSpan = reader.getNullable(JsonReader::getInt);
                } else if ("columnSpan".equals(fieldName)) {
                    columnSpan = reader.getNullable(JsonReader::getInt);
                } else if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                } else if ("elements".equals(fieldName)) {
                    elements = reader.readArray(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            DocumentTableCell deserializedDocumentTableCell
                = new DocumentTableCell(rowIndex, columnIndex, content, spans);
            deserializedDocumentTableCell.kind = kind;
            deserializedDocumentTableCell.rowSpan = rowSpan;
            deserializedDocumentTableCell.columnSpan = columnSpan;
            deserializedDocumentTableCell.boundingRegions = boundingRegions;
            deserializedDocumentTableCell.elements = elements;
            return deserializedDocumentTableCell;
        });
    }
}
