// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contiguous region of the concatenated content property, specified as an offset
 * and length.
 */
@Immutable
public final class DocumentSpan implements JsonSerializable<DocumentSpan> {

    /*
     * Zero-based index of the content represented by the span.
     */
    @Generated
    private final int offset;

    /*
     * Number of characters in the content represented by the span.
     */
    @Generated
    private final int length;

    /**
     * Creates an instance of DocumentSpan class.
     *
     * @param offset the offset value to set.
     * @param length the length value to set.
     */
    @Generated
    private DocumentSpan(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    /**
     * Get the offset property: Zero-based index of the content represented by the span.
     *
     * @return the offset value.
     */
    @Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Get the length property: Number of characters in the content represented by the span.
     *
     * @return the length value.
     */
    @Generated
    public int getLength() {
        return this.length;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentSpan from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentSpan if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentSpan.
     */
    @Generated
    public static DocumentSpan fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int offset = 0;
            int length = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("offset".equals(fieldName)) {
                    offset = reader.getInt();
                } else if ("length".equals(fieldName)) {
                    length = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }
            return new DocumentSpan(offset, length);
        });
    }
}
