// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An object representing a form field with distinct field label (key) and field
 * value (may be empty).
 */
@Immutable
public final class DocumentKeyValuePair implements JsonSerializable<DocumentKeyValuePair> {

    /*
     * Field label of the key-value pair.
     */
    @Generated
    private final DocumentKeyValueElement key;

    /*
     * Field value of the key-value pair.
     */
    @Generated
    private DocumentKeyValueElement value;

    /*
     * Confidence of correctly extracting the key-value pair.
     */
    @Generated
    private final double confidence;

    /**
     * Creates an instance of DocumentKeyValuePair class.
     *
     * @param key the key value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    private DocumentKeyValuePair(DocumentKeyValueElement key, double confidence) {
        this.key = key;
        this.confidence = confidence;
    }

    /**
     * Get the key property: Field label of the key-value pair.
     *
     * @return the key value.
     */
    @Generated
    public DocumentKeyValueElement getKey() {
        return this.key;
    }

    /**
     * Get the value property: Field value of the key-value pair.
     *
     * @return the value value.
     */
    @Generated
    public DocumentKeyValueElement getValue() {
        return this.value;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the key-value pair.
     *
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeJsonField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentKeyValuePair from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentKeyValuePair if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentKeyValuePair.
     */
    @Generated
    public static DocumentKeyValuePair fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentKeyValueElement key = null;
            double confidence = 0.0;
            DocumentKeyValueElement value = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = DocumentKeyValueElement.fromJson(reader);
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                } else if ("value".equals(fieldName)) {
                    value = DocumentKeyValueElement.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            DocumentKeyValuePair deserializedDocumentKeyValuePair = new DocumentKeyValuePair(key, confidence);
            deserializedDocumentKeyValuePair.value = value;
            return deserializedDocumentKeyValuePair;
        });
    }
}
