// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Operation status.
 */
public final class DocumentIntelligenceOperationStatus
    extends ExpandableStringEnum<DocumentIntelligenceOperationStatus> {

    /**
     * The operation has not started yet.
     */
    @Generated
    public static final DocumentIntelligenceOperationStatus NOT_STARTED = fromString("notStarted");

    /**
     * The operation is in progress.
     */
    @Generated
    public static final DocumentIntelligenceOperationStatus RUNNING = fromString("running");

    /**
     * The operation has failed.
     */
    @Generated
    public static final DocumentIntelligenceOperationStatus FAILED = fromString("failed");

    /**
     * The operation has succeeded.
     */
    @Generated
    public static final DocumentIntelligenceOperationStatus SUCCEEDED = fromString("succeeded");

    /**
     * The operation has been canceled.
     */
    @Generated
    public static final DocumentIntelligenceOperationStatus CANCELED = fromString("canceled");

    /**
     * The operation has been skipped.
     */
    @Generated
    public static final DocumentIntelligenceOperationStatus SKIPPED = fromString("skipped");

    /**
     * Creates a new instance of DocumentIntelligenceOperationStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public DocumentIntelligenceOperationStatus() {
    }

    /**
     * Creates or finds a DocumentIntelligenceOperationStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DocumentIntelligenceOperationStatus.
     */
    @Generated
    public static DocumentIntelligenceOperationStatus fromString(String name) {
        return fromString(name, DocumentIntelligenceOperationStatus.class);
    }

    /**
     * Gets known DocumentIntelligenceOperationStatus values.
     *
     * @return known DocumentIntelligenceOperationStatus values.
     */
    @Generated
    public static Collection<DocumentIntelligenceOperationStatus> values() {
        return values(DocumentIntelligenceOperationStatus.class);
    }
}
