// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Operation info.
 */
@Immutable
public class DocumentIntelligenceOperationDetails implements JsonSerializable<DocumentIntelligenceOperationDetails> {

    /*
     * Type of operation.
     */
    @Generated
    private OperationKind kind = OperationKind.fromString("DocumentIntelligenceOperationDetails");

    /*
     * Operation ID
     */
    @Generated
    private String operationId;

    /*
     * Operation status. notStarted, running, completed, or failed
     */
    @Generated
    private final DocumentIntelligenceOperationStatus status;

    /*
     * Operation progress (0-100).
     */
    @Generated
    private Integer percentCompleted;

    /*
     * Date and time (UTC) when the operation was created.
     */
    @Generated
    private final OffsetDateTime createdOn;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    @Generated
    private final OffsetDateTime lastUpdatedOn;

    /*
     * URL of the resource targeted by this operation.
     */
    @Generated
    private final String resourceLocation;

    /*
     * API version used to create this operation.
     */
    @Generated
    private String apiVersion;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Encountered error.
     */
    @Generated
    private DocumentIntelligenceError error;

    /**
     * Creates an instance of DocumentIntelligenceOperationDetails class.
     *
     * @param status the status value to set.
     * @param createdOn the createdOn value to set.
     * @param lastUpdatedOn the lastUpdatedOn value to set.
     * @param resourceLocation the resourceLocation value to set.
     */
    @Generated
    protected DocumentIntelligenceOperationDetails(DocumentIntelligenceOperationStatus status, OffsetDateTime createdOn,
        OffsetDateTime lastUpdatedOn, String resourceLocation) {
        this.status = status;
        this.createdOn = createdOn;
        this.lastUpdatedOn = lastUpdatedOn;
        this.resourceLocation = resourceLocation;
    }

    /**
     * Get the kind property: Type of operation.
     *
     * @return the kind value.
     */
    @Generated
    public OperationKind getKind() {
        return this.kind;
    }

    /**
     * Get the operationId property: Operation ID.
     *
     * @return the operationId value.
     */
    @Generated
    public String getOperationId() {
        return this.operationId;
    }

    /**
     * Set the operationId property: Operation ID.
     *
     * @param operationId the operationId value to set.
     * @return the DocumentIntelligenceOperationDetails object itself.
     */
    @Generated
    DocumentIntelligenceOperationDetails setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * Get the status property: Operation status. notStarted, running, completed, or failed.
     *
     * @return the status value.
     */
    @Generated
    public DocumentIntelligenceOperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the percentCompleted property: Operation progress (0-100).
     *
     * @return the percentCompleted value.
     */
    @Generated
    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    /**
     * Set the percentCompleted property: Operation progress (0-100).
     *
     * @param percentCompleted the percentCompleted value to set.
     * @return the DocumentIntelligenceOperationDetails object itself.
     */
    @Generated
    DocumentIntelligenceOperationDetails setPercentCompleted(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
        return this;
    }

    /**
     * Get the createdOn property: Date and time (UTC) when the operation was created.
     *
     * @return the createdOn value.
     */
    @Generated
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    /**
     * Get the lastUpdatedOn property: Date and time (UTC) when the status was last updated.
     *
     * @return the lastUpdatedOn value.
     */
    @Generated
    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    /**
     * Get the resourceLocation property: URL of the resource targeted by this operation.
     *
     * @return the resourceLocation value.
     */
    @Generated
    public String getResourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Get the apiVersion property: API version used to create this operation.
     *
     * @return the apiVersion value.
     */
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Set the apiVersion property: API version used to create this operation.
     *
     * @param apiVersion the apiVersion value to set.
     * @return the DocumentIntelligenceOperationDetails object itself.
     */
    @Generated
    DocumentIntelligenceOperationDetails setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     *
     * @param tags the tags value to set.
     * @return the DocumentIntelligenceOperationDetails object itself.
     */
    @Generated
    DocumentIntelligenceOperationDetails setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the error property: Encountered error.
     *
     * @return the error value.
     */
    @Generated
    public DocumentIntelligenceError getError() {
        return this.error;
    }

    /**
     * Set the error property: Encountered error.
     *
     * @param error the error value to set.
     * @return the DocumentIntelligenceOperationDetails object itself.
     */
    @Generated
    DocumentIntelligenceOperationDetails setError(DocumentIntelligenceError error) {
        this.error = error;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime",
            this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("lastUpdatedDateTime",
            this.lastUpdatedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedOn));
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("percentCompleted", this.percentCompleted);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentIntelligenceOperationDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentIntelligenceOperationDetails if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentIntelligenceOperationDetails.
     */
    @Generated
    public static DocumentIntelligenceOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("documentModelCompose".equals(discriminatorValue)) {
                    return DocumentModelComposeOperationDetails.fromJson(readerToUse.reset());
                } else if ("documentModelCopyTo".equals(discriminatorValue)) {
                    return DocumentModelCopyToOperationDetails.fromJson(readerToUse.reset());
                } else if ("documentClassifierCopyTo".equals(discriminatorValue)) {
                    return DocumentClassifierCopyToOperationDetails.fromJson(readerToUse.reset());
                } else if ("documentClassifierBuild".equals(discriminatorValue)) {
                    return DocumentClassifierBuildOperationDetails.fromJson(readerToUse.reset());
                } else if ("documentModelBuild".equals(discriminatorValue)) {
                    return DocumentModelBuildOperationDetails.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static DocumentIntelligenceOperationDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String operationId = null;
            DocumentIntelligenceOperationStatus status = null;
            OffsetDateTime createdOn = null;
            OffsetDateTime lastUpdatedOn = null;
            String resourceLocation = null;
            OperationKind kind = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map<String, String> tags = null;
            DocumentIntelligenceError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    kind = OperationKind.fromString(reader.getString());
                } else if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = reader.getNullable(JsonReader::getInt);
                } else if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            DocumentIntelligenceOperationDetails deserializedDocumentIntelligenceOperationDetails
                = new DocumentIntelligenceOperationDetails(status, createdOn, lastUpdatedOn, resourceLocation);
            deserializedDocumentIntelligenceOperationDetails.operationId = operationId;
            deserializedDocumentIntelligenceOperationDetails.kind = kind;
            deserializedDocumentIntelligenceOperationDetails.percentCompleted = percentCompleted;
            deserializedDocumentIntelligenceOperationDetails.apiVersion = apiVersion;
            deserializedDocumentIntelligenceOperationDetails.tags = tags;
            deserializedDocumentIntelligenceOperationDetails.error = error;
            return deserializedDocumentIntelligenceOperationDetails;
        });
    }
}
