// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceClientImpl;
import com.azure.ai.documentintelligence.models.AnalyzeBatchDocumentsOptions;
import com.azure.ai.documentintelligence.models.AnalyzeBatchOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeBatchResult;
import com.azure.ai.documentintelligence.models.AnalyzeDocumentOptions;
import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeOutputFormat;
import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.ai.documentintelligence.models.ClassifyDocumentOptions;
import com.azure.ai.documentintelligence.models.DocumentAnalysisFeature;
import com.azure.ai.documentintelligence.models.DocumentContentFormat;
import com.azure.ai.documentintelligence.models.SplitMode;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the asynchronous DocumentIntelligenceClient type.
 */
@ServiceClient(builder = DocumentIntelligenceClientBuilder.class, isAsync = true)
public final class DocumentIntelligenceAsyncClient {

    @Generated
    private final DocumentIntelligenceClientImpl serviceClient;

    /**
     * Initializes an instance of DocumentIntelligenceAsyncClient class.
     *
     * @param serviceClient the service client implementation.
     */
    @Generated
    DocumentIntelligenceAsyncClient(DocumentIntelligenceClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Gets the generated searchable PDF output from document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * BinaryData
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the generated searchable PDF output from document analysis along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultPdfWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeResultPdfWithResponseAsync(modelId, resultId, requestOptions);
    }

    /**
     * Gets the generated cropped image of specified figure from document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * BinaryData
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param figureId Figure ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the generated cropped image of specified figure from document analysis along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultFigureWithResponse(String modelId, String resultId,
        String figureId, RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeResultFigureWithResponseAsync(modelId, resultId, figureId, requestOptions);
    }

    /**
     * Mark the result of document analysis for deletion.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnalyzeResultWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        return this.serviceClient.deleteAnalyzeResultWithResponseAsync(modelId, resultId, requestOptions);
    }

    /**
     * List batch document analysis results.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of AnalyzeBatchOperation items as paginated response with {@link PagedFlux}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAnalyzeBatchResults(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.listAnalyzeBatchResultsAsync(modelId, requestOptions);
    }

    /**
     * Mark the batch document analysis result for deletion.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnalyzeBatchResultWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        return this.serviceClient.deleteAnalyzeBatchResultWithResponseAsync(modelId, resultId, requestOptions);
    }

    /**
     * Gets the result of batch document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the result of batch document analysis along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeBatchResultWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeBatchResultWithResponseAsync(modelId, resultId, requestOptions);
    }

    /**
     * Classifies document with document classifier.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>split</td><td>String</td><td>No</td><td>Document splitting mode. Allowed values: "auto", "none",
     * "perPage".</td></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     *
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocument(String classifierId, BinaryData classifyRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginClassifyDocumentAsync(classifierId, classifyRequest, requestOptions);
    }

    /**
     * /**
     * Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param analyzeDocumentOptions Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     * /
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocument(String modelId,
        AnalyzeDocumentOptions analyzeDocumentOptions) {
        Objects.requireNonNull(analyzeDocumentOptions, "'analyzeDocumentOptions' cannot be null.");
        return this.beginAnalyzeDocument(modelId, analyzeDocumentOptions,
            analyzeDocumentOptions.getPages() != null
                ? CoreUtils.stringJoin(",", analyzeDocumentOptions.getPages())
                : null,
            analyzeDocumentOptions.getLocale(), analyzeDocumentOptions.getStringIndexType(),
            analyzeDocumentOptions.getDocumentAnalysisFeatures(), analyzeDocumentOptions.getQueryFields(),
            analyzeDocumentOptions.getOutputContentFormat(), analyzeDocumentOptions.getOutput());
    }

    /**
     * Gets the generated searchable PDF output from document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the generated searchable PDF output from document analysis on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getAnalyzeResultPdf(String modelId, String resultId) {
        // Generated convenience method for getAnalyzeResultPdfWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getAnalyzeResultPdfWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono);
    }

    /**
     * Gets the generated cropped image of specified figure from document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param figureId Figure ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the generated cropped image of specified figure from document analysis on successful completion of
     * {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getAnalyzeResultFigure(String modelId, String resultId, String figureId) {
        // Generated convenience method for getAnalyzeResultFigureWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getAnalyzeResultFigureWithResponse(modelId, resultId, figureId, requestOptions)
            .flatMap(FluxUtil::toMono);
    }

    /**
     * Mark the result of document analysis for deletion.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAnalyzeResult(String modelId, String resultId) {
        // Generated convenience method for deleteAnalyzeResultWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return deleteAnalyzeResultWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono);
    }

    /**
     * /**
     * Analyzes batch documents with document model.
     *
     * @param modelId Unique document model name.
     * @param analyzeBatchDocumentOptions Analyze batch request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     * /
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocuments(String modelId,
        AnalyzeBatchDocumentsOptions analyzeBatchDocumentOptions) {
        Objects.requireNonNull(analyzeBatchDocumentOptions, "'analyzeBatchDocumentOptions' cannot be null.");
        return this.beginAnalyzeBatchDocuments(modelId, analyzeBatchDocumentOptions,
            analyzeBatchDocumentOptions.getPages() != null
                ? CoreUtils.stringJoin(",", analyzeBatchDocumentOptions.getPages())
                : null,
            analyzeBatchDocumentOptions.getLocale(), analyzeBatchDocumentOptions.getStringIndexType(),
            analyzeBatchDocumentOptions.getDocumentAnalysisFeatures(), analyzeBatchDocumentOptions.getQueryFields(),
            analyzeBatchDocumentOptions.getOutputContentFormat(), analyzeBatchDocumentOptions.getOutput());
    }

    /**
     * List batch document analysis results.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of AnalyzeBatchOperation items as paginated response with {@link PagedFlux}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnalyzeBatchOperationDetails> listAnalyzeBatchResults(String modelId) {
        // Generated convenience method for listAnalyzeBatchResults
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = listAnalyzeBatchResults(modelId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux<PagedResponse<BinaryData>> flux = (continuationTokenParam == null)
                ? pagedFluxResponse.byPage().take(1)
                : pagedFluxResponse.byPage(continuationTokenParam).take(1);
            return flux.map(pagedResponse -> new PagedResponseBase<Void, AnalyzeBatchOperationDetails>(
                pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(),
                pagedResponse.getValue()
                    .stream()
                    .map(protocolMethodData -> protocolMethodData.toObject(AnalyzeBatchOperationDetails.class))
                    .collect(Collectors.toList()),
                pagedResponse.getContinuationToken(), null));
        });
    }

    /**
     * Mark the batch document analysis result for deletion.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAnalyzeBatchResult(String modelId, String resultId) {
        // Generated convenience method for deleteAnalyzeBatchResultWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return deleteAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono);
    }

    /**
     * Gets the result of batch document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of batch document analysis on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeBatchOperationDetails> getAnalyzeBatchResult(String modelId, String resultId) {
        // Generated convenience method for getAnalyzeBatchResultWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono)
            .map(protocolMethodData -> protocolMethodData.toObject(AnalyzeBatchOperationDetails.class));
    }

    /**
     * /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param classifyDocumentOptions Classify request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     * /
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocument(String classifierId,
        ClassifyDocumentOptions classifyDocumentOptions) {
        Objects.requireNonNull(classifyDocumentOptions, "'classifyDocumentOptions' cannot be null.");
        return this.beginClassifyDocument(classifierId, classifyDocumentOptions,
            classifyDocumentOptions.getStringIndexType(), classifyDocumentOptions.getSplit(),
            classifyDocumentOptions.getPages() != null
                ? CoreUtils.stringJoin(",", classifyDocumentOptions.getPages())
                : null);
    }

    /**
     * Analyzes document with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, BinaryData analyzeRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginAnalyzeDocumentAsync(modelId, analyzeRequest, requestOptions);
    }

    /**
     * Analyzes batch documents with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     resultContainerUrl: String (Required)
     *     resultPrefix: String (Optional)
     *     overwriteExisting: Boolean (Optional)
     * }
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeBatchDocuments(String modelId, BinaryData analyzeBatchRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginAnalyzeBatchDocumentsAsync(modelId, analyzeBatchRequest, requestOptions);
    }

    /**
     * Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param pages 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param outputContentFormat Format of the analyze result top-level content.
     * @param output Additional outputs to generate during analysis.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocument(String modelId,
        AnalyzeDocumentOptions analyzeRequest, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, List<String> queryFields, DocumentContentFormat outputContentFormat,
        List<AnalyzeOutputFormat> output) {
        // Generated convenience method for beginAnalyzeDocumentWithModel
        RequestOptions requestOptions = new RequestOptions();
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        if (locale != null) {
            requestOptions.addQueryParam("locale", locale, false);
        }
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (features != null) {
            requestOptions.addQueryParam("features",
                features.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        if (queryFields != null) {
            requestOptions.addQueryParam("queryFields",
                queryFields.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        if (outputContentFormat != null) {
            requestOptions.addQueryParam("outputContentFormat", outputContentFormat.toString(), false);
        }
        if (output != null) {
            requestOptions.addQueryParam("output",
                output.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        return serviceClient.beginAnalyzeDocumentWithModelAsync(modelId, BinaryData.fromObject(analyzeRequest),
            requestOptions);
    }

    /**
     * Analyzes batch documents with document model.
     *
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param pages 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param outputContentFormat Format of the analyze result top-level content.
     * @param output Additional outputs to generate during analysis.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocuments(String modelId,
        AnalyzeBatchDocumentsOptions analyzeBatchRequest, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, List<String> queryFields, DocumentContentFormat outputContentFormat,
        List<AnalyzeOutputFormat> output) {
        // Generated convenience method for beginAnalyzeBatchDocumentsWithModel
        RequestOptions requestOptions = new RequestOptions();
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        if (locale != null) {
            requestOptions.addQueryParam("locale", locale, false);
        }
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (features != null) {
            requestOptions.addQueryParam("features",
                features.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        if (queryFields != null) {
            requestOptions.addQueryParam("queryFields",
                queryFields.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        if (outputContentFormat != null) {
            requestOptions.addQueryParam("outputContentFormat", outputContentFormat.toString(), false);
        }
        if (output != null) {
            requestOptions.addQueryParam("output",
                output.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        return serviceClient.beginAnalyzeBatchDocumentsWithModelAsync(modelId,
            BinaryData.fromObject(analyzeBatchRequest), requestOptions);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param stringIndexType Method used to compute string offset and length.
     * @param split Document splitting mode.
     * @param pages 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocument(String classifierId,
        ClassifyDocumentOptions classifyRequest, StringIndexType stringIndexType, SplitMode split, String pages) {
        // Generated convenience method for beginClassifyDocumentWithModel
        RequestOptions requestOptions = new RequestOptions();
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (split != null) {
            requestOptions.addQueryParam("split", split.toString(), false);
        }
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        return serviceClient.beginClassifyDocumentWithModelAsync(classifierId, BinaryData.fromObject(classifyRequest),
            requestOptions);
    }
}
