/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentSection
implements JsonSerializable<DocumentSection> {
    private final List<DocumentSpan> spans;
    private List<String> elements;

    private DocumentSection(List<DocumentSpan> spans) {
        this.spans = spans;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentSection fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentSection)jsonReader.readObject(reader -> {
            List spans = null;
            List elements = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentSection deserializedDocumentSection = new DocumentSection(spans);
            deserializedDocumentSection.elements = elements;
            return deserializedDocumentSection;
        });
    }
}

