/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentCaption
implements JsonSerializable<DocumentCaption> {
    private final String content;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;
    private List<String> elements;

    private DocumentCaption(String content, List<DocumentSpan> spans) {
        this.content = content;
        this.spans = spans;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentCaption fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentCaption)jsonReader.readObject(reader -> {
            String content = null;
            List spans = null;
            List boundingRegions = null;
            List elements = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentCaption deserializedDocumentCaption = new DocumentCaption(content, spans);
            deserializedDocumentCaption.boundingRegions = boundingRegions;
            deserializedDocumentCaption.elements = elements;
            return deserializedDocumentCaption;
        });
    }
}

